<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/" target="_blank" class="btn"><?php
						// Translators: %s: Analytify core version
						echo esc_html__( 'View Changelog', 'wp-analytify-authors' );
					?></a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . 'assets/img/logo.svg'?>" alt="Analytify">
				</div>
			</div>
		</div>

		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper">
						<?php echo $wp_analytify->dashboard_navigation(); ?>
					</div>

					<div class="wpb_plugin_tabs_content analytify-dashboard-content">
						<div class="analytify_wraper">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">
									<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Authors Dashboard', 'wp-analytify-authors' ); ?></h1>
									<?php
									if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection('Analytify') && $wp_analytify->pa_check_roles( $is_access_level ) && $access_token && method_exists( 'WPANALYTIFY_Utils', 'dashboard_subtitle_section' ) ) {
										WPANALYTIFY_Utils::dashboard_subtitle_section();
									}
									?>
								</div>
								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">
											<div class="analytify_authors_roles_wrapper">
												<label for="analytify-author-dashboard-select"><?php esc_html_e( 'Choose Author To View Stats:', 'wp-analytify-authors' ); ?></label>
												<select class="analytify_select_date_fields" id="analytify-author-dashboard-select" name="author_id">
													<?php
													echo '<option value="0">' . esc_html__( '- All Authors -', 'wp-analytify-authors' ) . '</option>';
													foreach ( $users as $user ) {
														$selected = '';
														if ( $user->ID === $current_user->ID ) {
															$selected = ' selected';
														}
														echo '<option value="' . $user->ID . '" ' . $selected . '>' . esc_html( $user->display_name ) . '</option>';
													}
													?>
												</select>
											</div>
											<?php
											if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection('Analytify') && $wp_analytify->pa_check_roles( $is_access_level ) && $access_token && method_exists( 'WPANALYTIFY_Utils', 'date_form' ) ) {
												WPANALYTIFY_Utils::date_form( $start_date, $end_date );
											}
											?>
										</div>
									</div>
								</div>
							</div>

							<div class="analytify_author_dashboard analytify_status_box_wraper" data-endpoint-authors="main-dashboard">
								<div class="analytify_status_header analytify_header_adj">
									<h3>
										<?php
										esc_html_e( 'Author Stats', 'wp-analytify-authors' );
										if ( defined( 'ANALYTIFY_PRO_VERSION' ) && 0 <= version_compare( ANALYTIFY_PRO_VERSION, '6.1.0' ) ) {
										?>
										<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="authors-dashboard" data-args="<?php echo $current_user->ID; ?>">
											<span class="analytify_tooltiptext"><?php esc_html_e( 'Export Stats', 'wp-analytify-pro' ); ?></span>
										</a>
										<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
										<?php } ?>
									</h3>
								</div>
								<div class="analytify_status_body">
									<div class="stats-wrapper"></div>
								</div>
								<div class="analytify_stats_loading">
									<table class="analytify_data_tables">
										<thead>
											<tr>
											<th class="analytify_num_row"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
											<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
											</tr>
										</thead>
										<tbody>
											<?php for ( $i = 0; $i < 7; $i++ ) { ?>
											<tr>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
												<td><p class="skt-loading"></p></td>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
												<td class="analytify_txt_center"><p class="skt-loading"></p></td>
											</tr>
											<?php } ?>
										</tbody>
									</table>
								</div>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
