<?php

//Get the start date and end date from wpa-core-functions
if ( function_exists( 'analytify_datepicker_dates' ) ) {
	extract( analytify_datepicker_dates() );
} else {
	$start_date = wp_date( 'Y-m-d', strtotime( '-1 month' ) );
	$end_date   = wp_date( 'Y-m-d', strtotime( 'now' ) );
}

$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
$dashboard_profile_id = $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' );
$dashboard_profile_id = method_exists( 'WPANALYTIFY_Utils', 'get_reporting_property' ) ? WPANALYTIFY_Utils::get_reporting_property() : $dashboard_profile_id;
$access_token         = get_option( 'post_analytics_token' );

/*
* Check with roles assigned at dashboard settings.
*/
$is_access_level = $wp_analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' );

// Show dashboard to admin incase of empty access roles.
if ( empty( $is_access_level ) ) {
	$is_access_level = array( 'administrator' );
}

$_analytify_profile = get_option( 'wp-analytify-profile' );

$version = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION; ?>

<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/" target="_blank" class="btn"><?php echo esc_html__( 'View Changelog', 'wp-analytify-campaigns' ); ?></a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'; ?>" alt="Analytify">
				</div>
			</div>
		</div>

		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper"> 
						<?php
						if ( method_exists( $wp_analytify, 'dashboard_navigation' ) ) {
							echo $wp_analytify->dashboard_navigation();
						}
						?>
					</div>
					<div class="wpb_plugin_tabs_content analytify-dashboard-content">			

						<div class="analytify_wraper">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">
									<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Campaigns Dashboard', 'wp-analytify-campaigns' ); ?></h1>
									<?php
									if ( $dashboard_profile_id ) {
										if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
											if ( $access_token && method_exists( 'WPANALYTIFY_Utils', 'dashboard_subtitle_section' ) ) {
												echo WPANALYTIFY_Utils::dashboard_subtitle_section();
											}
										}
									}
									?>
								</div>

								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">
											<?php
											if ( $dashboard_profile_id ) {
												if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
													if ( $access_token ) {
														if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' ) ) {
															WPANALYTIFY_Utils::date_form( $start_date, $end_date );
														}
													}
												}
											}
											?>
										</div>
									</div>
								</div>
								<!-- <div class="analytify_select_dashboard analytify_pull_right"><?php // do_action( 'analytify_dashboad_dropdown' ); ?></div> -->
							</div>

							<?php
							if( method_exists( 'WP_ANALYTIFY_FUNCTIONS', 'wpa_check_ga_version' ) && ! WP_ANALYTIFY_FUNCTIONS::wpa_check_ga_version() ) {

							}else if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
								if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
									if ( $access_token ) {
										?>

										<div class="analytify_general_status analytify_status_box_wraper analytify_campaigns_box_wrapper">
											<div class="analytify_status_header">
												<h3><?php esc_html_e( 'Overview', 'wp-analytify' ); ?></h3>
											</div>
											<div class="analytify_status_body stats_loading">
												<div id="wrapper_campaign"></div>
											</div>
											<div class="analytify_status_footer">
												<span class="analytify_info_stats"><?php printf( __( 'You are running %1$s Campaigns in total.', 'wp-analytify' ), '<span class="compaing-counter"></span>' ); ?></span>
											</div>
										</div>

										<script type="text/javascript">
										jQuery(document).ready(function ($) {
											load_campaigns_ajax();

											$(".analytify_form_date").on('submit', function(event) {
												event.preventDefault();
												load_campaigns_ajax();
											});

											function load_campaigns_ajax(){
												const start_date = $("#analytify_date_start").val();
												const end_date   = $("#analytify_date_end").val();

												$.ajax({
													url:  <?php echo wp_json_encode( esc_url_raw( rest_url( 'wp-analytify/v1/get_pro_campaigns_report/campaigns' ) ) ); ?>,
													data: {
														'sd' : start_date,
														'ed' : end_date,
													},
													beforeSend: function (xhr) {
														xhr.setRequestHeader( 'X-WP-Nonce', '<?php echo wp_create_nonce( 'wp_rest' ); ?>' );
														$('#wrapper_campaign').html('');
														$('#wrapper_campaign').parent().addClass("stats_loading");
													},
												})
												.fail(function() {
													var _html = '<table class="analytify_data_tables analytify_no_header_table"><tbody><tr><td class="analytify_td_error_msg"><div class="analytify-stats-error-msg"><div class="wpb-error-box"><span class="blk"><span class="line"></span><span class="dot"></span></span><span class="information-txt">Something Unexpected Occurred.</span></div></div></td></tr></tbody></table>'

													$('.analytify_demographic_detail_boxes_wraper').html(_html).parent().removeClass("stats_loading");
												})
												.done(function(data_array) {
													try {
														// var data_array = $.parseJSON(data);
														$('#wrapper_campaign').html( data_array.body );
														$('#wrapper_campaign').parent().removeClass("stats_loading");
														$('.compaing-counter').html( data_array.message );
													} catch (e) {
														$('#wrapper_campaign').parent().removeClass("stats_loading").html(data);
													}

													// Tooltip
													$( '.analytify-campaings-tooltip' ).tooltip({
														content: function () {
															return $(this).prop('title');
														},
														show: null,
														close: function (event, ui) {
														ui.tooltip.hover(
															function () {
																$(this).stop(true).fadeTo(400, 1);
															},
															function () {
																$(this).fadeOut("400", function () {
																	$(this).remove();
																});
															});
														},
														position: {
															my: 'left center',
															at: 'right+25 center',
															track: false,
															using: function( position, feedback ) {
																jQuery( this ).css( position );
																jQuery( "<div>" )
																.addClass( "arrow-tooltip" )
																.addClass( feedback.vertical )
																.addClass( feedback.horizontal )
																.appendTo( this );
															}
														}
													});
												});
											}
										});
										</script>

										<?php
									} else {
										esc_html_e( 'You must be authenticate to see the Analytics Campaigns Dashboard.', 'wp-analytify' );
									}
								}
							}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

