<?php

/**
 * Show General Performance of Digital Shop.
 *
 * @param  object $current Analytify Free Objext.
 * @param  object $stats   Contains stats that are fetch from google.
 *
 * @since  1.0.0
 */
function pa_include_edd( $current, $stats ) { 
	
	// Calculate Conversion Rate
    $sessions = isset( $stats['aggregations']['sessions'] ) ? $stats['aggregations']['sessions'] : 0;
    $transactions = isset( $stats['aggregations']['transactions'] ) ? $stats['aggregations']['transactions'] : 0;
    $conversion_rate = $sessions > 0 ? ( $transactions / $sessions ) * 100 : 0;

    // Get New Customer Rate
    $first_purchaser = isset( $stats['aggregations']['firstTimePurchaserRate'] ) ? $stats['aggregations']['firstTimePurchaserRate'] : 0;
	?>

	<div class="analytify_general_status analytify_status_box_wraper">
			<div class="analytify_status_header">
				<h3><?php esc_html_e( 'Overview', 'wp-analytify-edd' ); ?></h3>
			</div>
			<div class="analytify_status_body">
					<div class="analytify_general_status_boxes_wraper">
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Transactions', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
									<?php echo isset( $stats['aggregations']['transactions'] ) ? number_format($stats['aggregations']['transactions']) : number_format( 0, 2 ); ?>
								</div>
								<p><?php esc_html_e( 'Transactions is the total number of completed purchases on your site', 'wp-analytify-edd' ); ?>.</p>
							</div>
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Transaction Revenues', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
								<?php echo isset( $stats['aggregations']['totalRevenue'] ) 
								? edd_currency_symbol() . ( $stats['aggregations']['totalRevenue'] >= 1000 
									? number_format( $stats['aggregations']['totalRevenue'] / 1000, 2 ) . 'k' 
									: number_format( $stats['aggregations']['totalRevenue'], 2 ) ) 
								: edd_currency_symbol() . number_format( 0, 2 ); ?>
								</div>
								<p><?php esc_html_e( 'The total sale revenue provided in the transaction including or excluding shipping and tax.', 'wp-analytify-edd' ); ?></p>
							</div>
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Average Order Value', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
									<?php echo isset( $stats['aggregations']['averagePurchaseRevenue'] ) ? edd_currency_symbol() . number_format( $stats['aggregations']['averagePurchaseRevenue'], 2 ) : number_format( 0, 2 ); ?>
								</div>
								<p><?php esc_html_e( 'Average Value of transactions.', 'wp-analytify-edd' ); ?></p>
							</div>
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Product Adds To Cart', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
									<?php echo isset( $stats['aggregations']['addToCarts'] ) ? WPANALYTIFY_Utils::pretty_numbers( $stats['aggregations']['addToCarts'] ) : WPANALYTIFY_Utils::pretty_numbers( 0 ); ?>
								</div>
								<p><?php esc_html_e( 'The total number of items Added in cart whether it is purchased or not.', 'wp-analytify-edd' ); ?></p>
							</div>
							<!-- <div class="analytify_general_status_boxes">
									<h4><?php // esc_html_e( 'Product Removes From Cart', 'wp-analytify-edd' ); ?></h4>
									<div class="analytify_general_stats_value"><?php // echo $stats['aggregations']['ga:productRemovesFromCart']; ?></div>
									<p><?php // esc_html_e( 'The total number of items Removed from cart whether it is purchased or not.', 'wp-analytify-edd' ); ?></p>
							</div> -->
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Product Checkouts', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
									<?php echo isset( $stats['aggregations']['checkouts'] ) ? WPANALYTIFY_Utils::pretty_numbers( $stats['aggregations']['checkouts'] ) : WPANALYTIFY_Utils::pretty_numbers( 0 ); ?>
								</div>
								<p><?php esc_html_e( 'The total number of checkouts.', 'wp-analytify-edd' ); ?></p>
							</div>
							<!-- <div class="analytify_general_status_boxes">
									<h4><?php // esc_html_e( 'Refund Amount', 'wp-analytify-edd' ); ?></h4>
									<div class="analytify_general_stats_value"><?php // echo edd_currency_symbol() . number_format( $stats['aggregations']['ga:refundAmount'], 2 ); ?></div>
									<p><?php // esc_html_e( 'This is the total Refund amount. Minus it from Total Revenue to get the Net Revenue.', 'wp-analytify-edd' ); ?></p>
							</div> -->
							<!-- <div class="analytify_general_status_boxes">
									<h4><?php // esc_html_e( 'Total Refunds', 'wp-analytify-edd' ); ?></h4>
									<div class="analytify_general_stats_value"><?php // echo $stats['aggregations']['ga:totalRefunds']; ?></div>
									<p><?php // esc_html_e( 'The total number of refunds.', 'wp-analytify-edd' ); ?></p>
							</div> -->
							<div class="analytify_general_status_boxes">
								<h4><?php esc_html_e( 'Product Detail Views', 'wp-analytify-edd' ); ?></h4>
								<div class="analytify_general_stats_value">
									<?php echo isset( $stats['aggregations']['itemViews'] ) ? WPANALYTIFY_Utils::pretty_numbers( $stats['aggregations']['itemViews'] ) : WPANALYTIFY_Utils::pretty_numbers( 0 ); ?>
								</div>
								<p><?php esc_html_e( 'Number of times users viewed the product detail page.', 'wp-analytify-edd' ); ?></p>
							</div>
						<!-- New Conversion Rate Box -->
						<div class="analytify_general_status_boxes">
						<h4><?php esc_html_e( 'Conversion Rate', 'wp-analytify-edd' ); ?></h4>
						<div class="analytify_general_stats_value">
							<?php echo number_format( $conversion_rate, 2 ) . '%'; ?>
						</div>
						<p><?php esc_html_e( 'The percentage of website sessions resulting in a transaction.', 'wp-analytify-edd' ); ?></p>
					</div>

					<!-- New Customers Box -->
					<div class="analytify_general_status_boxes">
						<h4><?php esc_html_e( 'New Customers', 'wp-analytify-edd' ); ?></h4>
						<div class="analytify_general_stats_value">
							<?php echo number_format( $first_purchaser, 2 ) . '%'; ?>
						</div>
						<p><?php esc_html_e( 'The percentage of first-time purchasers.', 'wp-analytify-edd' ); ?></p>
					</div>
					</div>
			</div>
			<!-- <div class="analytify_status_footer">
					<span class="analytify_info_stats">
						<?php
						// echo sprintf( esc_html__( 'Did you know that the Conversion Rate in your store is %1$s', 'wp-analytify-edd' ), number_format( $stats['aggregations']['ga:transactionsPerSession'], 2) ) . '%'; 
						?>
					</span>
			</div> -->
	</div>

<?php } ?>
