<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
class Analytify_EDD_Loader
{
	public static $instance;
	public $version;

	public static function get_instance()
	{
		if (!isset(self::$instance)) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	public function __construct()
	{
		$this->version = '6.1.0';
		$this->define_constants();
		$this->hooks();
		$this->may_be_load_addon();
	}
	public function may_be_load_addon()
	{	
		/**
		* Check for EDD
		*/
	   if (!class_exists('Easy_Digital_Downloads')) {
		   add_action('admin_enqueue_scripts', array($this, 'wpa_edd_notices_scripts'));
		   return;
	    } elseif (
			file_exists(WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php')
			&& function_exists('wp_analytify_pro_load')
			&& class_exists('WP_Analytify_Pro_Base')
		) {
			include_once EDD_ANALYTIFY_PRO_PLUGIN_DIR . '/wp-analytify-edd-class.php';
			new WP_Analytify_Edd_Addon();
		} else {
			add_action('admin_enqueue_scripts', array($this, 'wpa_edd_notices_scripts'));
		}
	}

	public function define_constants()
	{
		define('EDD_ANALYTIFY_PRO_ADDON_VERSION', '6.1.0');
		define('EDD_ANALYTIFY_PRO_PLUGIN_DIR', dirname(__FILE__));
	}
	public function hooks()
	{
		add_action('admin_notices', array($this, 'wpa_edd_install_analytify_pro'));
		add_action('admin_notices', array($this, 'wpa_edd_active_analytify_pro'));
		add_action('admin_notices', array($this, 'install_edd'));
		add_action('admin_notices', array($this, 'active_edd'));
		add_action('init', array($this, 'wp_analytify_edd_load_text_domain'));
		add_action( 'admin_enqueue_scripts', array($this,'edd_admin_styles' ));
	}
	/**
	 * Admin notices scripts.
	 */
	public function wpa_edd_notices_scripts()
	{
		wp_enqueue_style('analytify-edd-notices', plugins_url('assets/css/notices.css', __FILE__), '', false, ANALYTIFY_PRO_VERSION);

	}

	public function wpa_edd_install_analytify_pro()
	{
		if (!file_exists(WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php')) {
			// $class   = 'notice notice-error is-dismissible';
			// printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
			$message = __('<strong>Attention:</strong> Please install Analytify Pro to use Analytify for Easy Digital Downloads addon.', 'wp-analytify-edd');

			$this->wp_analytify_edd_tracking_notice($message, 'wp-analytify-danger');
		}
	}

	public function wpa_edd_active_analytify_pro()
	{
		if (!class_exists('WP_Analytify_Pro_Base')) {
			// $class   = 'notice notice-error is-dismissible';
			// printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
			$message = __('<strong>Attention:</strong> Please active Analytify Pro to use Analytify for Easy Digital Downloads addon.', 'wp-analytify-edd');

			$this->wp_analytify_edd_tracking_notice($message, 'wp-analytify-danger');
		}
	}

	public function install_edd()
	{
		if (!file_exists(WP_PLUGIN_DIR . '/easy-digital-downloads/easy-digital-downloads.php') && !file_exists(WP_PLUGIN_DIR . '/easy-digital-downloads-pro/easy-digital-downloads.php')) {
			$message = __('<strong>Attention:</strong> Analytify for Easy Digital Downloads addon works with Easy Digital Downloads plugin, Please Install Easy Digital Downloads plugin.', 'wp-analytify-edd');

			$this->wp_analytify_edd_tracking_notice($message, 'wp-analytify-danger');
		}
	}

	public function active_edd()
	{
		if (file_exists(WP_PLUGIN_DIR . '/easy-digital-downloads/easy-digital-downloads.php') && !class_exists('Easy_Digital_Downloads')) {
			$message = __('<strong>Attention:</strong> Analytify for Easy Digital Downloads addon works with Easy Digital Downloads plugin, Please activate Easy Digital Downloads plugin.', 'wp-analytify-edd');

			$this->wp_analytify_edd_tracking_notice($message, 'wp-analytify-danger');
		}
	}

	/**
	 * Add custom admin notice
	 *
	 * @param  string $message Custom Message
	 * @param  string $class wp-analytify-success,wp-analytify-danger
	 */
	function wp_analytify_edd_tracking_notice( $message, $class = 'wp-analytify-success' ) {
		// Only show notices on allowed pages.
		$screen = get_current_screen();
		
		if ( ! $screen ) {
			return;
		}
		
		$allowed_parent_bases = array(
			'analytify-dashboard',
			'plugins',
			'analytify-settings',
			'analytify-license',
			'analytify-addons',
			'dashboard',
		);
		
		$allowed_screen_ids = array(
			'plugins',
			'dashboard',
		);
		
		// Check if we're on an allowed page.
		$is_allowed = in_array( $screen->parent_base, $allowed_parent_bases, true )
			|| in_array( $screen->id, $allowed_screen_ids, true )
			|| ( isset( $_GET['page'] ) && strpos( $_GET['page'], 'analytify' ) === 0 );
		
		// Don't show notice if not on allowed page.
		if ( ! $is_allowed ) {
			return;
		}
		
		$notice_id = 'analytify_notice_' . md5( $message );
		if ( ! get_option( $notice_id ) ) {
			echo '<div class="wp-analytify-notification '. $class .'" id="'. $notice_id .'">
					<a class="wp-analytify-notice-dismiss" href="#" aria-label="Dismiss the notice" onclick="dismissAnalytifyNotice(\''. $notice_id .'\'); return false;">&times;</a>
					<div class="wp-analytify-notice-logo">
						<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="notice">
					</div>
					<div class="wp-analytify-notice-discription">
						<p>' . $message .'</p>
					</div>
				</div>';
		}
	}
    
    public function wp_analytify_edd_notice_script() {
        ?>
        <script type="text/javascript">
            function dismissAnalytifyNotice(noticeId) {
                document.getElementById(noticeId).style.display = 'none';
                localStorage.setItem('analytify_stats_refreshed_dismissed', '1');
                var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
                var data = {
                    'action': 'dismiss_analytify_notice',
                    'notice_id': noticeId
                };
                jQuery.post(ajaxurl, data, function(response) {
                    console.log(response);
                });
            }
        </script>
        <?php
    }
    
    public function dismiss_analytify_edd_notice() {
        if ( isset( $_POST['notice_id'] ) ) {
            update_option( sanitize_text_field( $_POST['notice_id'] ), true );
            wp_send_json_success();
        } else {
            wp_send_json_error();
        }
    }

	/**
	 * Load TextDoamin
	 *
	 * @since 1.0.2
	 */
	public function wp_analytify_edd_load_text_domain()
	{
		$plugin_dir = basename(dirname(__FILE__));
		load_plugin_textdomain('wp-analytify-edd', false, $plugin_dir . '/languages/');
	}

	function edd_admin_styles() {
		wp_enqueue_style( 'wp-analytify-edd-funnel-style', plugins_url( 'assets/css/edd-funnel.css', __FILE__ ), false, EDD_ANALYTIFY_PRO_ADDON_VERSION );
		$analytify_plugin_url = plugin_dir_url( 'wp-analytify/wp-analytify.php' );
	}
}
Analytify_EDD_Loader::get_instance();
