<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Analytify_Email_Loader {

	public static $instance;

	public $version;

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {
		$this->version = '6.1.0';
		$this->define_constants();
		$this->hooks();
		$this->may_be_load_addon();
	}

	public function may_be_load_addon() {
		if (
			file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' )
			&& function_exists( 'wp_analytify_pro_load' )
			&& class_exists( 'Analytify_Email_Core' )
		) {
			include_once ANALYTIFY_EMAIL_ADDON_ROOT_PATH . 'wp-analytify-email-class.php';
			$wp_analytify_email_instance = new WP_Analytify_Addon_Email();
		}
	}

	public function define_constants() {
		$this->define( 'ANALTYIFY_EMAIL_ADDON_VERSION', $this->version );
		$this->define( 'ANALYTIFY_EMAIL_ADDON_ROOT_PATH', dirname( __FILE__ ) . '/' );
		$this->define( 'ANALYTIFY_IMAGES_PATH', 'https://analytify.io/assets/email/' );
		$this->define( 'ANALYTIFY_EMAIL_ADDON_UPGRADE_PATH', __FILE__ );
	}

	public function hooks() {
		add_action( 'admin_notices', array( $this, 'wpa_email_update_analytify_free' ) );
		add_action( 'admin_notices', array( $this, 'wpa_email_notices_scripts' ) );
		add_action( 'init', array( $this, 'wp_analytify_email_addon_load_text_domain' ) );
	}

	public function wpa_email_update_analytify_free() {
		if ( ! isset( $_GET['page'] ) || 'analytify-settings' !== $_GET['page'] || class_exists( 'Analytify_Email_Core' ) ) {
			return;
		}
		$message = esc_html__( 'Please Update Analytify Free to use Analytify Email Notifications addon.', 'wp-analytify-email' );
		$this->wpa_email_notice( $message, 'wp-analytify-danger' );
	}

	public function wpa_email_notices_scripts() {
		wp_enqueue_style( 'wpa-email-notices', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALTYIFY_EMAIL_ADDON_VERSION );
	}

	/**
	 * Add custom admin notice
	 *
	 * @param  string $message Custom Message
	 * @param  string $class wp-analytify-success,wp-analytify-danger
	 */
	public function wpa_email_notice( $message, $class ) {
		echo '<div class="wp-analytify-notification ' . $class . '">
		<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
		<div class="wp-analytify-notice-logo">
		<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
		</div>
		<div class="wp-analytify-notice-discription">
		<p>' . $message . '</p>
		</div>
		</div>';
	}

	public function wp_analytify_email_addon_load_text_domain() {
		$plugin_dir = basename( dirname( __FILE__ ) );
		load_plugin_textdomain( 'wp-analytify-email', false, $plugin_dir . '/languages/' );
	}

	public function define( $constant, $value ) {
		if ( ! defined( $constant ) ) {
			define( $constant, $value );
		}
	}

	/**
	 * Post activation house-keeping.
	 *
	 * @return void
	 */
	public static function wp_analytify_email_activation() {

		$_analytify_email = get_option( 'wp-analytify-email' );

		if ( empty( $_analytify_email ) || ! isset( $_analytify_email['analytif_email_cron_time'] ) ) {

			$default['analytify_email_stats'] = array(
				'show-overall-general',
				'show-top-pages',
				'show-geographics',
				'show-system',
				'show-system',
				'show-keywords',
				'show-social',
				'show-whats-happen',
				'show-referrer',
			);

			$default['analytify_email_user_email'] = get_bloginfo( 'admin_email' );
			$default['analytif_email_cron_time']   = array(
				'week'  => 'Monday',
				'month' => 'false',
			);

			update_option( 'wp-analytify-email', $default );
		}

		// Set default month option.
		if ( ! isset( $_analytify_email['analytif_email_cron_time']['month'] ) ) {
			$_analytify_email['analytif_email_cron_time']['month'] = 'false';

			update_option( 'wp-analytify-email', $_analytify_email );
		}
		// Set default week option.
		if ( ! isset( $_analytify_email['analytif_email_cron_time']['week'] ) ) {
			$_analytify_email['analytif_email_cron_time']['week'] = 'Monday';

			update_option( 'wp-analytify-email', $_analytify_email );
		}

	}

	/**
	 * Post deactivation house-keeping.
	 *
	 * @return void
	 */
	public static function wp_analytify_email_deactivation() {
		wp_clear_scheduled_hook( 'analytify_email_cron_function' );
	}
}

Analytify_Email_Loader::get_instance();

register_activation_hook( __FILE__, array( 'Analytify_Email_Loader', 'wp_analytify_email_activation' ) );



register_deactivation_hook( __FILE__, array( 'Analytify_Email_Loader', 'wp_analytify_email_deactivation' ) );

/**
 * Helper function for translation.
 */
if ( ! function_exists( 'analytify__' ) ) {
	/**
	 * Wrapper for __() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify__( $string, $textdomain = 'wp-analytify' ) {
		return __( $string, $textdomain );
	}
}

if ( ! function_exists( 'analytify_e' ) ) {
	/**
	 * Wrapper for _e() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify_e( $string, $textdomain = 'wp-analytify' ) {
		echo __( $string, $textdomain );
	}
}
