<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$search_term_value = isset( $_GET['analytify_search_terms_search'] ) ? $_GET['analytify_search_terms_search'] : '';
$search_term_value = esc_attr( $search_term_value );

?>
<div class="analytify_general_status analytify_status_box_wraper" data-endpoint-pro="search-terms">
	<div class="analytify_status_header" style="display: flex;">
		<h3 style="width: 25%; padding-top: 14px;">
			<?php esc_html_e( 'Search Terms Stats', 'wp-analytify-pro' ); ?>
			<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="search-terms"><span class="analytify_tooltiptext"><?php esc_html_e( 'Export Stats', 'wp-analytify-pro' ); ?></span></a>
			<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
		</h3>
		<form id="analytify-search-terms-search-form" class="analytify-search-form" style="width:100%;">
			<input
				type="text"
				name="analytify_search_terms_search"
				id="analytify_search_terms_search"
				class="analytify-search-input"
				style="width: 40%; float:right;"
				placeholder="<?php esc_attr_e( 'Search terms...', 'wp-analytify-pro' ); ?>"
				value="<?php echo $search_term_value; ?>" />
		</form>

	</div>
	<div class="analytify_status_body">
		<div class="analytify-search-console-header">
			<div class="analytify-table-toolbar">
			</div>
		</div>
		<div class="stats-wrapper"></div>
	</div>
	<div class="analytify_stats_loading">
		<table class="analytify_data_tables">
			<thead>
				<tr>
					<th class="analytify_num_row">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_txt_left">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row">
						<p class="skt-loading light-gray"></p>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php for ( $i = 0; $i < 5; $i++ ) { ?>
					<tr>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
						<td>
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>
