<section id="kpt-panes-settings" class="ksp-tab-content">
<div class="kpt-pane-actions">
	<div style="float: left;">
		<a class="ksp-button ksp-is-primary ksp-save-settings" data-id="<?php echo esc_attr($id); ?>" href="#"><?php _e('Save Settings', 'kadence-pricing-table'); ?></a>		
		<a class="ksp-add-pane ksp-button"><?php _e('Add Column', 'kadence-pricing-table'); ?></a>
	</div>
	<div style="clear: both;"></div>
</div>
<div id="kpt-panes">
			<?php
			if($edit) {
				if(isset($table->text_align) ){
					$aligncss = $table->text_align;
				} else {
					$aligncss = 'center';
				}
				if(isset($table->hover_effect) ){
					$hovercss = $table->hover_effect;
				} else {
					$hovercss = 'none';
				}
				if(isset($table->template) ){
					$skincss = $table->template;
				} else {
					$skincss = 'flat';
				}
				if(!empty($panes)) {
					$j = 0;
					$tablenum = count($panes);
					echo '<ul class="ksp-sortable ksp-clearfix kpt-table-editing-area table-align-'.esc_attr($aligncss).' table-hover-'.esc_attr($hovercss).' table-skin-'.esc_attr($skincss).' table-pane-count-'.esc_attr($tablenum).'" style="text-align:center;">';
					foreach($panes as $pane) {
						if($j == $tablenum - 1) {
							echo '<li class="kpt-pane kt-ui-default active">';
						} else {
							echo '<li class="kpt-pane kt-ui-default">';
						}
							echo '<div class="pane-controls-settings">';
							echo '<span class="ksp-duplicate" title="'.__("Duplicate", 'kadence-pricing-table').'"></span>';
							echo '<span class="ksp-close" title="'.__("Delete", 'kadence-pricing-table').'"></span>';
							echo '</div>';
							echo '<div class="pane-controls">';
							echo __('Column', 'kadence-pricing-table') . ' <span class="kpt-pane-index">' . (($pane->position) + 1) . '</span>';
							echo '</div>';
							kpt_admin_output_pane($table, $pane, $edit);

						echo '</li>';
						$j++;
					}
					echo '</ul>';
					echo '<div class="pane-settings">';
					foreach($panes as $pane) {

						kpt_admin_output_pane_edit($table, $pane, $edit);
					}
					echo '</div>';
				} else {
					echo '<ul class="ksp-sortable ksp-clearfix kpt-table-editing-area table-align-'.esc_attr($aligncss).' table-pane-count-1" style="text-align:center;">';
					echo '<li class="kpt-pane kt-ui-default">';
					echo '<div class="pane-controls-settings">';
					echo '<span class="ksp-duplicate" title="'.__("Duplicate", 'kadence-pricing-table').'"></span>';
					echo '<span class="ksp-close" title="'.__("Delete", 'kadence-pricing-table').'"></span>';
					echo '</div>';
					echo '<div class="pane-controls">';
					echo __('Column', 'kadence-pricing-table') . ' <span class="kpt-pane-index">1</span>';
					echo '</div>';
						kpt_admin_output_pane($table, false, $edit);
					echo '</li>';
					echo '</ul>';
					echo '<div class="pane-settings">';
						kpt_admin_output_pane_edit($table, false, $edit);
					echo '</div>';
				}
			}
			?>
			
			<div class="kpt-void-pane"><?php
				echo '<li class="kpt-pane kt-ui-default">';
				echo '<div class="pane-controls-settings">';
					echo '<span class="ksp-duplicate" title="'.__("Duplicate", 'kadence-pricing-table').'"></span>';
					echo '<span class="ksp-close" title="'.__("Delete", 'kadence-pricing-table').'"></span>';
					echo '</div>';
					echo '<div class="pane-controls">';
					echo  __('Column', 'kadence-pricing-table') . ' <span class="kpt-pane-index">0</span>';
					echo '</div>';
					kpt_admin_output_pane($table, false, $edit);
				echo '</li>';
					?>
			</div>
			<div class="kpt-void-pane-edit">
			<?php kpt_admin_output_pane_edit($table, false, $edit); ?>
			</div>
		<div style="clear: both"></div>
</div>
</section>

<?php

function kpt_admin_output_pane_edit($table, $pane, $edit) {
	$void = !$pane ? true : false;
	$data = kpt_row_data($pane);
	$featured = array(
		'none' => array(__('None', 'kadence-pricing-table'), true),
		'ribbon' => array(__('Ribbon', 'kadence-pricing-table'), false),
		'badge' => array(__('Badge', 'kadence-pricing-table'), false),
		'scale' => array(__('Scale', 'kadence-pricing-table'), false),
	);
	?>
	<div class="kpt-pane-settings-list ksp-table">
		<div class="ksp-row pane-settings-contain pane-top-settings">
			<div class="ksp-list-title">
					<?php _e('Top Row Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
								<div class="ksp-column ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Top Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-top_html">' . esc_textarea($data['top_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-top_image">
									<span class="ksp-inner-row-label">
										<?php _e('Top Image', 'kadence-pricing-table'); ?>
									</span>
									<?php
										if(!empty($data['top_image'])) {
											echo '<input data-src="'.esc_attr($data['top_image']).'" class="kpt-image-upload-button ksp-button ksp-is-default" type="button" value="' . __('Edit Image', 'kadence-slider') . '" />';
											echo '<input class="kpt-image-remove-button ksp-button ksp-is-default" type="button" value="' . __('Remove Image', 'kadence-slider') . '" />';
										} else {
											echo '<input data-src="" class="kpt-image-upload-button ksp-button ksp-is-default" type="button" value="' . __('Add Image', 'kadence-slider') . '" />';
										}
									?>
								</div>
								<div class="ksp-column ksp-even kpt-top_font kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['top_font']);
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-top_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['top_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-top_font_size kt_small_input" type="number" value="' . esc_attr($data['top_font_size']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Line height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-top_line_height kt_small_input" type="number" value="' . esc_attr($data['top_line_height']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-top_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['top_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Top and Bottom Padding', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-top_padding kt_small_input" type="number" value="' .esc_attr($data['top_padding']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Top Row Background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-top_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['top_bg_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Top Row Min-Height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-top_height kt_small_input" type="number" value="' . esc_attr($data['top_height']) .'" />';
										?>
										px
							</div>
							</div>
					</div>
				</div>
			</div>
		</div>
		<div class="ksp-row pane-settings-contain pane-price-settings">
			<div class="ksp-list-title">
					<?php _e('Price Row Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
								<div class="ksp-column ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Price Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-price_html">' . esc_textarea($data['price_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-price_font">
									<span class="ksp-inner-row-label">
										<?php _e('Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['price_font']);
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-price_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['price_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_font_size kt_small_input" type="number" value="' . esc_attr($data['price_font_size']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Line height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_line_height kt_small_input" type="number" value="' . esc_attr($data['price_line_height']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['price_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Price Sub Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-price_sub_html">' . esc_textarea($data['price_sub_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-price_sub_font">
									<span class="ksp-inner-row-label">
										<?php _e('Sub Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['price_sub_font']);
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Sub Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-price_sub_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['price_sub_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Sub Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_sub_font_size kt_small_input" type="number" value="' . esc_attr($data['price_sub_font_size']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Sub Line height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_sub_line_height kt_small_input" type="number" value="' . esc_attr($data['price_sub_line_height']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Sub Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_sub_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['price_sub_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-33">
									<span class="ksp-inner-row-label">
										<?php _e('Top and Bottom Padding', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-price_padding kt_small_input" type="number" value="' .esc_attr($data['price_padding']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-33">
										<span class="ksp-inner-row-label">
											<?php _e('Price Row Background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-price_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['price_bg_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-33">
										<span class="ksp-inner-row-label">
											<?php _e('Price Row Min-Height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-price_height kt_small_input" type="number" value="' . esc_attr($data['price_height']) .'" />';
										?>
										px
							</div>
							</div>
					</div>
				</div>
			</div>
		</div>
		<div class="ksp-row pane-settings-contain pane-description-settings">
			<div class="ksp-list-title">
					<?php _e('Description Row Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
								<div class="ksp-column kpt-column-full ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Description Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-description_html">' . esc_textarea($data['description_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-description_font kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['description_font']);
									?>
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-description_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['description_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-description_font_size kt_small_input" type="number" value="' . esc_attr($data['description_font_size']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Line height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-description_line_height kt_small_input" type="number" value="' . esc_attr($data['description_line_height']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-description_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['description_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Top and Bottom Padding', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-description_padding kt_small_input" type="number" value="' .esc_attr($data['description_padding']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Description Row Background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-description_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['description_bg_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Description Row Min-Height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-description_height kt_small_input" type="number" value="' . esc_attr($data['description_height']) .'" />';
										?>
										px
							</div>
							</div>
					</div>
				</div>
			</div>
		</div>
		<div class="ksp-row pane-settings-contain pane-row-settings">
		<?php if(!$void) {
					global $wpdb;
					$id = isset($_GET['id']) ? $_GET['id'] : NULL;
					$pane_parent = $pane->position;
					$table_rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tablerows WHERE table_parent = ' . $id . ' AND pane_parent = ' . $pane_parent . ' ORDER BY position');
				} else {
					$pane_parent = NULL;
					$table_rows = NULL;
				}
				kpt_admin_output_table_rows_settings($edit, $table, $pane, $table_rows);
				?>
		</div>
		<?php // Footer ?>
		<div class="ksp-row pane-settings-contain pane-footer-settings">
			<div class="ksp-list-title">
					<?php _e('Footer Row Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
							<div class="ksp-column-outer ksp-btn-text">
								<div class="ksp-column ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Footer Button Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-footer_html">' . esc_textarea($data['footer_html']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-footer_font">
									<span class="ksp-inner-row-label">
										<?php _e('Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['footer_font']);
									?>
								</div>
							</div>
							<div class="ksp-column-outer ksp-odd ksp-btn-colors">
								<div class="ksp-column ksp-even">
									<span class="ksp-inner-row-label">
										<?php _e('Font Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-footer_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['footer_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd">
									<span class="ksp-inner-row-label">
										<?php _e('Button Background Color', 'kadence-pricing-table'); ?>
									</span>
										<input class="kpt-footer_btn_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_btn_background']); ?>" />
								</div>
								<div class="ksp-column ksp-even">
									<span class="ksp-inner-row-label">
										<?php _e('Button Border Color', 'kadence-pricing-table'); ?>
									</span>
										<input class="kpt-footer_btn_border_color kpt-color-button ksp-border-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_btn_border_color']);  ?>" />
								</div>
								<div class="ksp-clearfix">
									<div class="ksp-column ksp-odd">
										<span class="ksp-inner-row-label">
											<?php _e('Font Hover Color', 'kadence-pricing-table'); ?>
										</span>
											<input class="kpt-footer_color_hover kpt-color-button ksp-hcolor-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_color_hover']); ?>" />
									</div>
									<div class="ksp-column ksp-even">
										<span class="ksp-inner-row-label">
											<?php _e('Button Background Hover Color', 'kadence-pricing-table'); ?>
										</span>
											<input class="kpt-footer_btn_background_hover kpt-color-button ksp-hbackground-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_btn_background_hover']); ?>" />
									</div>
									<div class="ksp-column ksp-odd">
										<span class="ksp-inner-row-label">
											<?php _e('Border Hover Color', 'kadence-pricing-table'); ?>
										</span>
											<input class="kpt-footer_btn_border_color_hover kpt-color-button ksp-hborder-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_btn_border_color_hover']); ?>" />
									</div>
								</div>
							</div>
							<div class="ksp-clearfix ksp_fonts_container">
								<div class="ksp-odd ksp-btn-fontstyling">
									<div class="ksp-column ksp-odd">
										<span class="ksp-inner-row-label">
											<?php _e('Font Size', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_font_size kt_small_input" type="number" value="' . esc_attr($data['footer_font_size']) .'" />';
										 ?>
										px
									</div>
									<div class="ksp-column ksp-even">
										<span class="ksp-inner-row-label">
											<?php _e('Line height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_line_height kt_small_input" type="number" value="' . esc_attr($data['footer_line_height']) .'" />';
										?>
										px
									</div>
									<div class="ksp-column ksp-odd">
										<span class="ksp-inner-row-label">
											<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['footer_letter_spacing']) .'" />';
										?>
										px
									</div>
									<div class="ksp-column ksp-even">
										<span class="ksp-inner-row-label">
											<?php _e('Border Width', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_btn_border_width kt_small_input" type="number" value="' .  esc_attr($data['footer_btn_border_width']) .'" />';
										?>
										px
									</div>
									<div class="ksp-column ksp-odd">
										<span class="ksp-inner-row-label">
											<?php _e('Border Radius', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_btn_border_radius kt_small_input" type="number" value="' . esc_attr($data['footer_btn_border_radius']) .'" />';
										?>
										px
									</div>
									<div class="ksp-column ksp-even">
										<span class="ksp-inner-row-label">
											<?php _e('Left and Right Padding', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_btn_padding kt_small_input" type="number" value="' .esc_attr($data['footer_btn_padding']).'" />';
										?>
										px
									</div>
								</div>
								<div class="ksp-column ksp-even column-footer-bg">
										<span class="ksp-inner-row-label">
											<?php _e('Footer Row Background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-footer_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['footer_bg_color']); ?>" />
								</div>
								<div class="ksp-column ksp-odd column-footer-height">
										<span class="ksp-inner-row-label">
											<?php _e('Footer Row Height', 'kadence-pricing-table'); ?>
										</span>
										<?php
											echo '<input class="kpt-footer_height kt_small_input" type="number" value="' . esc_attr($data['footer_height']) .'" />';
										?>
										px
								</div>
								<div class="ksp-column ksp-even column-link-background">
									<span class="ksp-inner-row-label">
										<?php _e('Link', 'kadence-pricing-table'); ?>
										</span>
									<?php
										echo '<input class="kpt-footer_btn_link" type="text" value="' . esc_attr($data['footer_link']) .'" />';
										if($data['footer_link_new_tab']) {
											echo '<input class="kpt-footer_btn_link_new_tab" type="checkbox" checked />' . __('Open link in a new tab', 'kadence-pricing-table');
										} else {
											echo '<input class="kpt-footer_btn_link_new_tab" type="checkbox" />' . __('Open link in a new tab', 'kadence-pricing-table');
										}
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="ksp-row pane-settings-contain pane-featured-settings">
			<div class="ksp-list-title">
					<?php _e('Column Options', 'kadence-pricing-table'); ?>
			</div>
			<div class="ksp-column ksp-full">
				<div class="ksp-content">
					<div class="ksp-inner-row ksp-btn-options ksp-clearfix">
						<div class="ksp-border-wrap ksp-clearfix">
								<div class="ksp-column ksp-odd kpt-column-33">
									<span class="ksp-inner-row-label">
										<?php _e('Border width', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_border_width kt_small_input" type="number" value="' . esc_attr($data['featured_border_width']) .'" />';
									 ?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-33">
									<span class="ksp-inner-row-label">
										<?php _e('Border Color', 'kadence-pricing-table'); ?>
									</span>
									<input class="kpt-featured_border_color kpt-color-button ksp-bcolor-wp-color-picker kpt-color" type="text" value="<?php echo esc_attr($data['featured_border_color']); ?>" />
								</div>
								
								<div class="ksp-column ksp-even kpt-column-33">
									<span class="ksp-inner-row-label">
										<?php _e('Border Radius', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_border_radius kt_small_input" type="number" value="' . esc_attr($data['featured_border_radius']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-top_font kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Enable Featured Column', 'kadence-pricing-table'); ?>
									</span>
									<div class="ksp-content">
										<select class="kpt-feature-column">
										<?php
											foreach($featured as $key => $value) {
												echo '<option value="' . esc_attr($key) . '"';
												if((!$edit && $key == "none") || ($edit && $data['featured'] == $key)) {
													echo ' selected';
												}
												echo '>' . esc_html($value[0]) . '</option>';
											}
										?>
										</select>
									</div>
								</div>
								<div class="ksp-column ksp-odd  kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Feature Text', 'kadence-pricing-table'); ?>
									</span>
									<?php					
										echo '<textarea class="kpt-inner-html kpt-featured_text">' . esc_textarea($data['featured_text']) . '</textarea>';
									?>
								</div>
								<div class="ksp-column ksp-even kpt-column-25">
										<span class="ksp-inner-row-label">
											<?php _e('Font Color', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-featured_color kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['featured_color']); ?>" />
								</div>
								<div class="ksp-column ksp-even kpt-featured_font kpt-column-25">
									<span class="ksp-inner-row-label">
										<?php _e('Feature Font', 'kadence-pricing-table'); ?>
									</span>
									<?php
									echo kpt_font_list_select($data['featured_font']);
									?>
								</div>
								<div class="ksp-column ksp-even kpt-column-20">
									<span class="ksp-inner-row-label">
										<?php _e('Font Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_font_size kt_small_input" type="number" value="' .esc_attr($data['featured_font_size']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-20">
									<span class="ksp-inner-row-label">
										<?php _e('Line Height', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_line_height kt_small_input" type="number" value="' .esc_attr($data['featured_line_height']).'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-20">
									<span class="ksp-inner-row-label">
										<?php _e('Letter Spacing', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_letter_spacing kt_small_input" type="number" value="' . esc_attr($data['featured_letter_spacing']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-odd kpt-column-20">
									<span class="ksp-inner-row-label">
										<?php _e('Size', 'kadence-pricing-table'); ?>
									</span>
									<?php
										echo '<input class="kpt-featured_size kt_small_input" type="number" value="' . esc_attr($data['featured_size']) .'" />';
									?>
									px
								</div>
								<div class="ksp-column ksp-even kpt-column-20">
										<span class="ksp-inner-row-label">
											<?php _e('Badge/Ribbon background', 'kadence-pricing-table'); ?>
										</span>
										<input class="kpt-featured_background kpt-color-button ksp-background-wp-color-picker ksp-btn-color" type="text" value="<?php echo esc_attr($data['featured_background']); ?>" />
								</div>
							</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}

function kpt_row_data($pane) {
	$void = !$pane ? true : false;
	$fontdata = get_option('kadence_pricing_table');
	$data = array();
	if(!$void) {
		$data['top_bg_color'] = $pane->top_head_background;
		$data['top_color'] = $pane->top_head_color;
		$data['top_font_size']= $pane->top_head_font_size;
		$data['top_letter_spacing'] = $pane->top_head_letter_spacing;
		$data['top_line_height'] = $pane->top_head_line_height;
		$data['top_font'] = $pane->top_head_font;
		$data['top_height'] = $pane->top_head_height;
		$data['top_padding'] = $pane->top_head_padding;
		$data['top_html'] = $pane->top_head_html;
		$data['top_icon'] = $pane->top_head_icon;
		$data['top_image'] = $pane->top_head_image;
	} else {
		$data['top_bg_color'] = '#f3733c';
		$data['top_color'] = '#ffffff';
		$data['top_font_size'] = '16';
		$data['top_letter_spacing'] = '0';
		$data['top_line_height'] = '20';
		$data['top_font'] = 'font_option_three';
		$data['top_height'] = '40';
		$data['top_padding'] = '4';
		$data['top_html'] = __('PRO PLAN', 'kadence-pricing-table');
		$data['top_icon'] = '';
		$data['top_image'] = '';
	}
	if(isset($fontdata[$data['top_font']]['font-family'])) {
		$data['top_font_family'] = 'font-family: ' . $fontdata[$data['top_font']]['font-family'] . ';'; 
	} else {
		$data['top_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['top_font']]['font-weight'])) { 
		$data['top_font_weight'] = 'font-weight: ' . $fontdata[$data['top_font']]['font-weight'] . ';'; 
	} else {
		$data['top_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['top_font']]['font-style'])) { 
		$data['top_font_style'] = 'font-style: ' . $fontdata[$data['top_font']]['font-style'] . ';'; 
	} else {
		$data['top_font_style'] = '';
	} 
	// Pricing section
	if(!$void) {
		$data['price_bg_color'] = $pane->price_background;
		$data['price_color'] = $pane->price_color;
		$data['price_font_size'] = $pane->price_font_size;
		$data['price_letter_spacing'] = $pane->price_letter_spacing;
		$data['price_line_height'] = $pane->price_line_height;
		$data['price_font'] = $pane->price_font;
		$data['price_sub_color'] = $pane->price_sub_color;
		$data['price_sub_font_size'] = $pane->price_sub_font_size;
		$data['price_sub_letter_spacing'] = $pane->price_sub_letter_spacing;
		$data['price_sub_line_height'] = $pane->price_sub_line_height;
		$data['price_sub_font'] = $pane->price_sub_font;
		$data['price_height'] = $pane->price_height;
		$data['price_padding'] = $pane->price_padding;
		$data['price_html'] = $pane->price_html;
		$data['price_sub_html'] = $pane->price_sub_html;
	} else {
		$data['price_bg_color'] = '#f26224';
		$data['price_color'] = '#ffffff';
		$data['price_font_size'] = '50';
		$data['price_letter_spacing'] = '0';
		$data['price_line_height'] = '60';
		$data['price_font'] = 'font_option_one';
		$data['price_sub_color'] = '#ffffff';
		$data['price_sub_font_size'] = '12';
		$data['price_sub_letter_spacing'] = '0';
		$data['price_sub_line_height'] = '16';
		$data['price_sub_font'] = 'font_option_three';
		$data['price_padding'] = '10';
		$data['price_height'] = '140';
		$data['price_html'] = __('$30', 'kadence-pricing-table');
		$data['price_sub_html'] =  __('ONE TIME FEE', 'kadence-pricing-table');
	}
	if(isset($fontdata[$data['price_font']]['font-family'])) {
		$data['price_font_family'] = 'font-family: ' . $fontdata[$data['price_font']]['font-family'] . ';'; 
	} else {
		$data['price_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['price_font']]['font-weight'])) { 
		$data['price_font_weight'] = 'font-weight: ' . $fontdata[$data['price_font']]['font-weight'] . ';'; 
	} else {
		$data['price_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['price_font']]['font-style'])) { 
		$data['price_font_style'] = 'font-style: ' . $fontdata[$data['price_font']]['font-style'] . ';'; 
	} else {
		$data['price_font_style'] = '';
	} 

	if(isset($fontdata[$data['price_sub_font']]['font-family'])) {
		$data['price_sub_font_family'] = 'font-family: ' . $fontdata[$data['price_sub_font']]['font-family'] . ';'; 
	} else {
		$data['price_sub_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['price_sub_font']]['font-weight'])) { 
		$data['price_sub_font_weight'] = 'font-weight: ' . $fontdata[$data['price_sub_font']]['font-weight'] . ';'; 
	} else {
		$data['price_sub_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['price_sub_font']]['font-style'])) { 
		$data['price_sub_font_style'] = 'font-style: ' . $fontdata[$data['price_sub_font']]['font-style'] . ';'; 
	} else {
		$data['price_sub_font_style'] = '';
	} 

	// Description section
	if(!$void) {
		$data['description_bg_color'] = $pane->description_background;
		$data['description_color'] = $pane->description_color;
		$data['description_font_size'] = $pane->description_font_size;
		$data['description_letter_spacing'] = $pane->description_letter_spacing;
		$data['description_line_height'] = $pane->description_line_height;
		$data['description_font'] = $pane->description_font;
		$data['description_padding'] = $pane->description_padding;
		$data['description_height'] = $pane->description_height;
		$data['description_html'] = $pane->description_html;
	} else {
		$data['description_bg_color'] = '#ffffff';
		$data['description_color'] = '#444444';
		$data['description_font_size'] = '14';
		$data['description_letter_spacing'] = '0';
		$data['description_line_height'] = '20';
		$data['description_font'] = 'font_option_three';
		$data['description_padding'] = '10';
		$data['description_height'] = '80';
		$data['description_html'] = __('Description of pricing column, here you can add details in more paragraph form.', 'kadence-pricing-table');
	}
	if(isset($fontdata[$data['description_font']]['font-family'])) {
		$data['description_font_family'] = 'font-family: ' . $fontdata[$data['description_font']]['font-family'] . ';'; 
	} else {
		$data['description_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['description_font']]['font-weight'])) { 
		$data['description_font_weight'] = 'font-weight: ' . $fontdata[$data['description_font']]['font-weight'] . ';'; 
	} else {
		$data['description_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['description_font']]['font-style'])) { 
		$data['description_font_style'] = 'font-style: ' . $fontdata[$data['description_font']]['font-style'] . ';'; 
	} else {
		$data['description_font_style'] = '';
	} 

	// Footer 

	if(!$void) {
		$data['footer_bg_color'] = $pane->footer_background;
		$data['footer_color'] = $pane->footer_color;
		$data['footer_color_hover'] = $pane->footer_color_hover;
		$data['footer_font_size'] = $pane->footer_font_size;
		$data['footer_letter_spacing'] = $pane->footer_letter_spacing;
		$data['footer_line_height'] = $pane->footer_line_height;
		$data['footer_btn_background'] = $pane->footer_btn_background;
		$data['footer_btn_background_hover'] = $pane->footer_btn_background_hover;
		$data['footer_btn_border_color'] = $pane->footer_btn_border_color;
		$data['footer_btn_border_color_hover'] = $pane->footer_btn_border_color_hover;
		$data['footer_btn_border_width'] = $pane->footer_btn_border_width;
		$data['footer_btn_border_radius'] = $pane->footer_btn_border_radius;
		$data['footer_btn_padding'] = $pane->footer_btn_padding;
		$data['footer_font'] = $pane->footer_font;
		$data['footer_height'] = $pane->footer_height;
		$data['footer_link'] = $pane->footer_link;
		$data['footer_link_new_tab'] = $pane->footer_link_new_tab;
		$data['footer_html'] = $pane->footer_html;
	} else {
		$data['footer_bg_color'] = '#f26224';
		$data['footer_color'] = '#ffffff';
		$data['footer_color_hover'] = '#ffffff';
		$data['footer_font_size'] = '14';
		$data['footer_letter_spacing'] = '0';
		$data['footer_line_height'] = '30';
		$data['footer_btn_background'] = '#f26224';
		$data['footer_btn_background_hover'] = '#f3733c';
		$data['footer_btn_border_color'] = '#ffffff';
		$data['footer_btn_border_color_hover'] = '#ffffff';
		$data['footer_btn_border_width'] = '2';
		$data['footer_btn_border_radius'] = '4';
		$data['footer_btn_padding'] = '8';
		$data['footer_font'] = 'font_option_one';
		$data['footer_height'] = '60';
		$data['footer_link'] = '';
		$data['footer_link_new_tab'] = '0';
		$data['footer_html'] = __('Sign Up', 'kadence-pricing-table');
	}
	if(isset($fontdata[$data['footer_font']]['font-family'])) {
		$data['footer_font_family'] = 'font-family: ' . $fontdata[$data['footer_font']]['font-family'] . ';'; 
	} else {
		$data['footer_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['footer_font']]['font-weight'])) { 
		$data['footer_font_weight'] = 'font-weight: ' . $fontdata[$data['footer_font']]['font-weight'] . ';'; 
	} else {
		$data['footer_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['footer_font']]['font-style'])) { 
		$data['footer_font_style'] = 'font-style: ' . $fontdata[$data['footer_font']]['font-style'] . ';'; 
	} else {
		$data['footer_font_style'] = '';
	} 

	if(!$void) {
		$data['featured'] = $pane->featured;
		$data['featured_background'] = $pane->featured_background;
		$data['featured_color'] = $pane->featured_color;
		$data['featured_font_size']= $pane->featured_font_size;
		$data['featured_letter_spacing'] = $pane->featured_letter_spacing;
		$data['featured_line_height'] = $pane->featured_line_height;
		$data['featured_font'] = $pane->featured_font;
		$data['featured_border_width'] = $pane->featured_border_width;
		$data['featured_border_color'] = $pane->featured_border_color;
		$data['featured_border_radius'] = $pane->featured_border_radius;
		$data['featured_size'] = $pane->featured_size;
		$data['featured_text'] = $pane->featured_text;
	} else {
		$data['featured'] = 'false';
		$data['featured_background'] = '#ffffff';
		$data['featured_color'] = '#f3733c';
		$data['featured_font_size']= '16';
		$data['featured_letter_spacing'] = '1';
		$data['featured_line_height'] = '20';
		$data['featured_font'] = 'font_option_three';
		$data['featured_border_width'] = '0';
		$data['featured_border_color'] = '#ffffff';
		$data['featured_border_radius'] = '0';
		$data['featured_size'] = '60';
		$data['featured_text'] = __('FEATURED', 'kadence-pricing-table');
	}
	if(isset($fontdata[$data['featured_font']]['font-family'])) {
		$data['featured_font_family'] = 'font-family: ' . $fontdata[$data['featured_font']]['font-family'] . ';'; 
	} else {
		$data['featured_font_family'] = 'font-family: Open Sans;'; 
	}
	if(isset($fontdata[$data['featured_font']]['font-weight'])) { 
		$data['featured_font_weight'] = 'font-weight: ' . $fontdata[$data['featured_font']]['font-weight'] . ';'; 
	} else {
		$data['featured_font_weight'] = 'font-weight: 600;'; 
	}
	if(isset($fontdata[$data['featured_font']]['font-style'])) { 
		$data['featured_font_style'] = 'font-style: ' . $fontdata[$data['featured_font']]['font-style'] . ';'; 
	} else {
		$data['featured_font_style'] = '';
	} 
	return $data;
}
function kpt_admin_output_pane($table, $pane, $edit) {
	$void = !$pane ? true : false;
	$data = kpt_row_data($pane);

	
	echo '<div class="kt-table-pane kt-pane-style-'.esc_attr($data['featured']).'" style="border-width:'.esc_attr($data['featured_border_width']).'px; border-color:'.esc_attr($data['featured_border_color']).'; border-radius:'.esc_attr($data['featured_border_radius']).'px">';
			
	$template_order = array('top_head', 'price', 'description', 'rows', 'footer');
	foreach ($template_order as $key) {
		switch($key) {

			case 'top_head':
				// Top Head
				if($data['top_height'] == '0') {
					$data['top_height'] = '5';
				}
				echo '<div class="kpt-pane-top-head kpt-section" style="background:'.esc_attr($data['top_bg_color']).'; color:'.esc_attr($data['top_color']).'; font-size:'.esc_attr($data['top_font_size']).'px; letter-spacing:'.esc_attr($data['top_letter_spacing']).'px; line-height:'.esc_attr($data['top_line_height']).'px; padding-top:'.esc_attr($data['top_padding']).'px; padding-bottom:'.esc_attr($data['top_padding']).'px; min-height:'.esc_attr($data['top_height']).'px; '.esc_attr($data['top_font_family']).' '.esc_attr($data['top_font_weight']).' '.esc_attr($data['top_font_style']).'">';
					echo '<div class="kpt-top-head-text">';
						echo wp_kses_post($data['top_html']);
					echo '</div>';
					if(!empty($data['top_icon'])) {
						echo '<div class="kpt-top-head-icon">';
							echo '<i class="'.esc_attr($data['top_icon']).'"></i>';
						echo '</div>';
					}
					echo '<div class="kpt-top-head-image">';
					if(!empty($data['top_image'])) {
							echo '<img src="'.esc_attr($data['top_image']).'" atr="'.esc_attr($data['top_html']).'" class="kpt-top-image">';
					}
					echo '</div>';
				echo '</div>';
			break;
			case 'price': 
				// Price Section
				if($data['price_height'] == '0') {
					$data['price_height'] = '5';
				}
				echo '<div class="kpt-pane-price kpt-section" style="background:'.esc_attr($data['price_bg_color']).'; color:'.esc_attr($data['price_color']).'; font-size:'.esc_attr($data['price_font_size']).'px; letter-spacing:'.esc_attr($data['price_letter_spacing']).'px; line-height:'.esc_attr($data['price_line_height']).'px; min-height:'.esc_attr($data['price_height']).'px; padding-top:'.esc_attr($data['price_padding']).'px; padding-bottom:'.esc_attr($data['price_padding']).'px; '.esc_attr($data['price_font_family']).' '.esc_attr($data['price_font_weight']).' '.esc_attr($data['price_font_style']).'">';
					echo '<div class="kpt-price-inner">';
						echo wp_kses_post($data['price_html']);
					echo '</div>';
						echo '<div class="kpt-price-sub" style="color:'.esc_attr($data['price_sub_color']).'; font-size:'.esc_attr($data['price_sub_font_size']).'px; letter-spacing:'.esc_attr($data['price_sub_letter_spacing']).'px; line-height:'.esc_attr($data['price_sub_line_height']).'px; '.esc_attr($data['price_sub_font_family']).' '.esc_attr($data['price_sub_font_weight']).' '.esc_attr($data['price_sub_font_style']).'">';
						if(!empty($data['price_sub_html'])) {
							echo wp_kses_post($data['price_sub_html']);
						}
						echo '</div>';
				echo '</div>';
			break;
			case 'description': 
				// Description
				if($data['description_height'] == '0') {
					$data['description_height'] = '5';
				}
				echo '<div class="kpt-pane-description kpt-section" style="background:'.esc_attr($data['description_bg_color']).'; color:'.esc_attr($data['description_color']).'; font-size:'.esc_attr($data['description_font_size']).'px; letter-spacing:'.esc_attr($data['description_letter_spacing']).'px; line-height:'.esc_attr($data['description_line_height']).'px; padding-top:'.esc_attr($data['description_padding']).'px; padding-bottom:'.esc_attr($data['description_padding']).'px; min-height:'.esc_attr($data['description_height']).'px; '.esc_attr($data['description_font_family']).' '.esc_attr($data['description_font_weight']).' '.esc_attr($data['description_font_style']).'">';
					echo wp_kses_post($data['description_html']);
				echo '</div>';
			break;
			case 'rows': 
				echo '<div class="kpt-pane-rows kpt-section">';
				if(!$void) {
					global $wpdb;
					$id = isset($_GET['id']) ? $_GET['id'] : NULL;
					$pane_parent = $pane->position;
					$table_rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tablerows WHERE table_parent = ' . $id . ' AND pane_parent = ' . $pane_parent. ' ORDER BY position');
				}
				else {
					$pane_parent = NULL;
					$table_rows = NULL;
				}
				kpt_admin_output_table_rows($edit, $table, $pane, $table_rows);
				echo '</div>';
			break;
			case 'footer': 
				// $footer_
				if($data['footer_height'] == '0') {
					$data['footer_height'] = '5';
				}
				echo '<div class="kpt-pane-footer kpt-section" style="background:'.esc_attr($data['footer_bg_color']).'; color:'.esc_attr($data['footer_color']).'; font-size:'.esc_attr($data['footer_font_size']).'px; letter-spacing:'.esc_attr($data['footer_letter_spacing']).'px; line-height:'.esc_attr($data['footer_line_height']).'px; height:'.esc_attr($data['footer_height']).'px; '.esc_attr($data['footer_font_family']).' '.esc_attr($data['footer_font_weight']).' '.esc_attr($data['footer_font_style']).'">';
					echo '<a href="" class="kpt-footer-btn" style="background:'.esc_attr($data['footer_btn_background']).'; color:'.esc_attr($data['footer_color']).'; border:'.esc_attr($data['footer_btn_border_width']).'px solid; border-color:'.esc_attr($data['footer_btn_border_color']).'; border-radius:'.esc_attr($data['footer_btn_border_radius']).'px; padding-left:'.esc_attr($data['footer_btn_padding']).'px; padding-right:'.esc_attr($data['footer_btn_padding']).'px;" data-color="' . esc_attr($data['footer_color']). '" data-border-color="' . esc_attr($data['footer_btn_border_color']). '" data-background-color="' . esc_attr($data['footer_btn_background']). '" data-hcolor="' . esc_attr($data['footer_color_hover']). '" data-hborder-color="' . esc_attr($data['footer_btn_border_color_hover']). '" data-hbackground-color="' . esc_attr($data['footer_btn_background_hover']). '">'.wp_kses_post($data['footer_html']).'</a>';
				echo '</div>';
			break;	
			echo '<div class="kpt-pane-featured kpt-section"></div>';
		}

	}
	echo '<div class="kpt-featured-item featured-style-'.esc_attr($data['featured']).'" style="background:'.esc_attr($data['featured_background']).'; color:'.esc_attr($data['featured_color']).'; font-size:'.esc_attr($data['featured_font_size']).'px; letter-spacing:'.esc_attr($data['featured_letter_spacing']).'px; line-height:'.esc_attr($data['featured_line_height']).'px; height:'.esc_attr($data['featured_size']).'px; width:'.esc_attr($data['featured_size']).'px; '.esc_attr($data['featured_font_family']).' '.esc_attr($data['featured_font_weight']).' '.esc_attr($data['featured_font_style']).'">';
			echo '<div class="kpt-featured_inner" style="background:'.esc_attr($data['featured_background']).';">';
				echo wp_kses_post($data['featured_text']);
			echo '</div>';
			echo '</div>';
	?>
	</div>

<?php 
}
?>