<?php

defined( 'ABSPATH' ) or exit;

/**
 * Admin setup
 *
 */
class Kadence_Woocommerce_Elementor_Pro_Admin {

	/**
	* @var null
	*/
	private static $instance = null;


	/**
	* Instance Control
	*/
	public static function get_instance() {
		if ( is_null(  self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor
	 */
	private function __construct() {
		// Add to settings
		add_filter( 'wc_settings_kadence_template_builder', array( $this, 'add_settings'), 50 );

		//Built Custom Post types
		add_action( 'init', array( $this, 'elementor_woo_pro_posttypes' ) );
		// // Add Menu Item
		add_action( 'admin_menu', array( $this, 'register_admin_menu' ), 60 );

		// Admin Css
		add_action('admin_enqueue_scripts', array( $this, 'admin_enqueues' ) );

		// Make sure it's not public.
		add_action( 'template_redirect', array( $this, 'block_pro_template_frontend' ) );

		// Use fullwidth template when editing
		add_filter( 'single_template', array( $this, 'pro_load_fullwidth_template' ) );

		// Use fullwidth template when editing
		add_filter( 'single_template', array( $this, 'pro_load_loop_template' ) );

		// Use fullwidth template when editing
		add_filter( 'single_template', array( $this, 'pro_load_checkout_template' ) );

		// Add archive settings.
		add_action( 'admin_init', array( $this, 'archive_template_meta' ) );

		add_action( 'add_meta_boxes', array( $this, 'remove_wp_seo_meta_box' ), 100 );

	}
	/**
	 * Remove SEO Meta Box
	 */
	public function remove_wp_seo_meta_box() {
		remove_meta_box( 'wpseo_meta', 'ele-p-loop-template', 'normal' );
		remove_meta_box( 'wpseo_meta', 'ele-p-arch-template', 'normal' );
		remove_meta_box( 'wpseo_meta', 'ele-check-template', 'normal' );
	}
	/**
	 * Remove Archive template meta
	 */
	public function archive_template_meta() {
		if ( ! class_exists( 'Kadence_Taxonomy_Meta' ) )
			return;

		$meta_sections = array();

		$meta_sections[] = array(
			'title'      => __( 'Elementor Archive Template Settings', 'kadence-woocommerce-elementor-pro'), 
			'taxonomies' => array('product_cat', 'product_tag'),
			'id'         => 'kwetb_archive',

			'fields' => array(
				array(
					'name' => __( 'Product archive template', 'kadence-woocommerce-elementor-pro' ),
					'desc' => __( 'Choose a builder template', 'kadence-woocommerce-elementor-pro' ),
					'id'   => 'kwetb_archive_template',
					'type'    => 'select',
					'options' => self::get_posts_with_default( array( 'post_type' => 'ele-p-arch-template', 'numberposts' => 100 ) ),
				),
			),
		);
		$meta_sections[] = array(
			'title'      => __( 'Elementor Products in Category Template Settings', 'kadence-woocommerce-elementor-pro' ),
			'taxonomies' => array( 'product_cat' ),
			'id'         => 'kwetb_archive_assign',

			'fields' => array(
				array(
					'name' => __( 'Assign a Product template to entire cateogry', 'kadence-woocommerce-elementor-pro' ),
					'desc' => __( 'Every Product with this category will use this builder template as the default', 'kadence-woocommerce-elementor-pro' ),
					'id'   => 'kwetb_assigned_template',
					'type'    => 'select',
					'options' => self::get_posts_with_default( array( 'post_type' => 'ele-product-template', 'numberposts' => 100 ) ),
				),
			),
		);

		foreach ( $meta_sections as $meta_section ) { 
			new Kadence_Taxonomy_Meta( $meta_section );
		}
	}
	public static function add_settings( $settings ) {
		unset( $settings['kt_woo_ele_pro'] );
		$new_settings = array(
			'section_archive_title' => array(
				'name'     => __( 'Archive Product Settings', 'kadence-woocommerce-elementor-pro' ),
				'type'     => 'title',
				'desc'     => '',
				'id'       => 'wc_settings_kadence_archive_template_builder_title'
			),
			'kt_woo_ele_shop' => array(
				'name' => __( 'Choose a default template for Shop page', 'kadence-woocommerce-elementor-pro' ),
				'type' => 'select',
				'default'  => 'default',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'id'   => 'kt_woo_ele_shop_template_default',
				'options'  =>  self::get_posts_with_default( array( 'post_type' => 'ele-p-arch-template', 'numberposts' => -1 ) )
			),
			'kt_woo_ele_category' => array(
				'name' => __( 'Choose a default template for Category Archives', 'kadence-woocommerce-elementor-pro' ),
				'type' => 'select',
				'default'  => 'default',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'id'   => 'kt_woo_ele_category_template_default',
				'options'  =>  self::get_posts_with_default( array( 'post_type' => 'ele-p-arch-template', 'numberposts' => -1 ) )
			),
			'kt_woo_ele_tag' => array(
				'name' => __( 'Choose a default template for Tag Archives', 'kadence-woocommerce-elementor-pro' ),
				'type' => 'select',
				'default'  => 'default',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'id'   => 'kt_woo_ele_tag_template_default',
				'options'  =>  self::get_posts_with_default( array( 'post_type' => 'ele-p-arch-template', 'numberposts' => -1 ) )
			),
			'section_archive_end' => array(
				'type' => 'sectionend',
				'id' => 'wc_settings_kadence_archive_template_builder_end'
			),
			'section_loop_title' => array(
				'name'     => __( 'Product Loop Content Settings', 'kadence-woocommerce-elementor-pro' ),
				'type'     => 'title',
				'desc'     => '',
				'id'       => 'wc_settings_kadence_loop_template_builder_title'
			),
			'kt_woo_ele_loop' => array(
				'name' => __( 'Choose a default template for Product Loop Content', 'kadence-woocommerce-elementor-pro' ),
				'type' => 'select',
				'default'  => 'default',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'id'   => 'kt_woo_ele_loop_template_default',
				'options'  =>  self::get_posts_with_default( array( 'post_type' => 'ele-p-loop-template', 'numberposts' => -1 ) )
			),
			'section_loop_end' => array(
				'type' => 'sectionend',
				'id' => 'wc_settings_kadence_loop_template_builder_end'
			),
			'section_checkout_title' => array(
				'name'     => __( 'Checkout Settings', 'kadence-woocommerce-elementor-pro' ),
				'type'     => 'title',
				'desc'     => '',
				'id'       => 'wc_settings_kadence_checkout_template_builder_title'
			),
			'kt_woo_ele_checkout' => array(
				'name' => __( 'Choose a default template for Checkout page', 'kadence-woocommerce-elementor-pro' ),
				'type' => 'select',
				'default'  => 'default',
				'css'      => 'min-width: 350px;',
				'class'    => 'wc-enhanced-select',
				'id'   => 'kt_woo_ele_checkout_template_default',
				'options'  =>  self::get_posts_with_default( array( 'post_type' => 'ele-check-template', 'numberposts' => -1 ) )
			),
			'section_checkout_end' => array(
				'type' => 'sectionend',
				'id' => 'wc_settings_kadence_checkout_template_builder_end'
			),
		);
		return array_merge($settings ,$new_settings);
	}

	public static function get_posts_with_default( $query_args ) {
		$args = wp_parse_args( $query_args, array(
			'post_type'   => 'post',
			'numberposts' => 100,
		) );

		$posts = get_posts( $args );

		$post_options = array();
		$post_options['default'] = __( 'Default', 'kadence-woocommerce-elementor-pro' );
		if ( $posts ) {
			foreach ( $posts as $post ) {
				$post_options[$post->ID] = 'WC Elementor - ' . $post->post_title;
			}
		}

		return $post_options;
	}
	/**
	 * Register Post type for woo elementor templates
	 */
	public function elementor_woo_pro_posttypes() {

		$archive_labels = array(
			'name'               => __( 'Woo Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'singular_name'      => __( 'Elementor Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'menu_name'          => __( 'Elementor Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'name_admin_bar'     => __( 'Elementor Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'add_new'            => __( 'Add New', 'kadence-woocommerce-elementor-pro' ),
			'add_new_item'       => __( 'Add New Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'new_item'           => __( 'New Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'edit_item'          => __( 'Edit Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'view_item'          => __( 'View Archive Template', 'kadence-woocommerce-elementor-pro' ),
			'all_items'          => __( 'All Elementor Archive Templates', 'kadence-woocommerce-elementor-pro' ),
			'search_items'       => __( 'Search Archive Templates', 'kadence-woocommerce-elementor-pro' ),
			'parent_item_colon'  => __( 'Parent Archive Templates:', 'kadence-woocommerce-elementor-pro' ),
			'not_found'          => __( 'No Archive Templates found.', 'kadence-woocommerce-elementor-pro' ),
			'not_found_in_trash' => __( 'No Archive Templates found in Trash.', 'kadence-woocommerce-elementor-pro' ),
		);

		$archive_args = array(
			'labels'              => $archive_labels,
			'public'              => true,
			'rewrite'             => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'supports'            => array( 'title', 'revisions', 'elementor' ),
		);
		register_post_type( 'ele-p-arch-template', $archive_args );

		$loop_labels = array(
			'name'               => __( 'Woo Archive Loop Content Template', 'kadence-woocommerce-elementor-pro' ),
			'singular_name'      => __( 'Elementor Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'menu_name'          => __( 'Elementor Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'name_admin_bar'     => __( 'Elementor Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'add_new'            => __( 'Add New', 'kadence-woocommerce-elementor-pro' ),
			'add_new_item'       => __( 'Add New Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'new_item'           => __( 'New Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'edit_item'          => __( 'Edit Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'view_item'          => __( 'View Product Loop Template', 'kadence-woocommerce-elementor-pro' ),
			'all_items'          => __( 'All Elementor Product Loop Templates', 'kadence-woocommerce-elementor-pro' ),
			'search_items'       => __( 'Search Product Loop Templates', 'kadence-woocommerce-elementor-pro' ),
			'parent_item_colon'  => __( 'Parent Product Loop Templates:', 'kadence-woocommerce-elementor-pro' ),
			'not_found'          => __( 'No Product Loop Templates found.', 'kadence-woocommerce-elementor-pro' ),
			'not_found_in_trash' => __( 'No Product Loop Templates found in Trash.', 'kadence-woocommerce-elementor-pro' ),
		);

		$loop_args = array(
			'labels'              => $loop_labels,
			'public'              => true,
			'rewrite'             => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'supports'            => array( 'title', 'revisions', 'elementor' ),
		);
		register_post_type( 'ele-p-loop-template', $loop_args );

		$checkout_labels = array(
			'name'               => __( 'Woo Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'singular_name'      => __( 'Elementor Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'menu_name'          => __( 'Elementor Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'name_admin_bar'     => __( 'Elementor Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'add_new'            => __( 'Add New', 'kadence-woocommerce-elementor-pro' ),
			'add_new_item'       => __( 'Add New Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'new_item'           => __( 'New Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'edit_item'          => __( 'Edit Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'view_item'          => __( 'View Checkout Template', 'kadence-woocommerce-elementor-pro' ),
			'all_items'          => __( 'All Elementor Checkout Templates', 'kadence-woocommerce-elementor-pro' ),
			'search_items'       => __( 'Search Checkout Templates', 'kadence-woocommerce-elementor-pro' ),
			'parent_item_colon'  => __( 'Parent Checkout Templates:', 'kadence-woocommerce-elementor-pro' ),
			'not_found'          => __( 'No Checkout Templates found.', 'kadence-woocommerce-elementor-pro' ),
			'not_found_in_trash' => __( 'No Checkout Templates found in Trash.', 'kadence-woocommerce-elementor-pro' ),
		);

		$checkout_args = array(
			'labels'              => $checkout_labels,
			'public'              => true,
			'rewrite'             => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'supports'            => array( 'title', 'revisions', 'elementor' ),
		);

		register_post_type( 'ele-check-template', $checkout_args );
	}

	/**
	 * Register the admin menu for templates builder.
	 *
	 */
	public function register_admin_menu() {
		remove_submenu_page( 'edit.php?post_type=product', 'edit.php?post_type=ele-product-template' );
		add_submenu_page( 
			'edit.php?post_type=product',
			__( 'Woo Templates', 'kadence-woocommerce-elementor-pro' ),
			__( 'Woo Templates', 'kadence-woocommerce-elementor-pro' ),
			'edit_pages',
			'kadence_woo_ele_templates',
			array( $this, 'template_overview')
		);
	}
	public static function admin_enqueues($hook) {
		if( $hook != 'product_page_kadence_woo_ele_templates' ) {
			return;
		}
		wp_enqueue_style('kadence-woo-template-builder-admin', KT_WOOELE_PRO_URL . 'assets/css/admin-kwep.css', false, KT_WOOELE_PRO_VERSION);
		
	}
	public function template_overview(){
		?>
		<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>
		
		<div class="wrap kwt-admin-page kwt-admin">	
			<?php 
			$post_loop = null; 
			$post_loop = new WP_Query();
			$post_loop->query(array(
				'orderby' => 'DESC',
				'order' => 'date',
				'post_type' => 'ele-product-template',
				'posts_per_page' => '-1'));
			if ($post_loop ) : ?>
			<div class="kwt-templates-list kwt-products kwt-table kwt-clearfix">
				<div class="kwt-table-title">
					<h3>
						<?php _e('Single Product Templates', 'kadence-woocommerce-elementor-pro'); ?>
					</h3>
				</div>
				<div class="kwt_table_body kwt-clearfix">
					<div class="kwt-table-header kwt-clearfix">
						<div class="kwt-table-column kwt_column_01"><?php _e('Name', 'kadence-woocommerce-elementor-pro'); ?></div>
						<div class="kwt-table-column kwt_column_02"><?php _e('Actions', 'kadence-woocommerce-elementor-pro'); ?></div>
					</div>

					<?php 
			 		if (!$post_loop->have_posts()) : ?>
				        <div class="kwt-no-temlplates">
							<?php echo __('No Templates found. Please add a new one.', 'kadence-woocommerce-elementor-pro'); ?>
						</div>
	       			<?php 
        			endif;

					while ($post_loop->have_posts() ) :$post_loop->the_post();
					global $post;
					?>
						<div class="kwt_table_content kwt_table_row kwt-clearfix">
							<div class="kwt-table-column kwt_column_01"><a href="<?php echo esc_url(get_edit_post_link($post->ID));?>"><?php echo get_the_title();?></a></div>
							<div class="kwt-table-column kwt_column_02">
								<a class="kwt-edit-template kwt-button kwt-button kwt-is-success" href="<?php echo get_edit_post_link($post->ID);?>"><?php echo __('Edit Template', 'kadence-woocommerce-elementor-pro');?></a>
								<a class="kwt-delete-template kwt-button kwt-button kwt-is-danger" href="<?php echo get_delete_post_link($post->ID);?>"><?php echo __('Delete Template', 'kadence-woocommerce-elementor-pro');?></a>
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			</div>

			<?php endif; 
				wp_reset_query();
			?>
			<a class="kwt-button kwt-is-primary kwt-add-template" href="<?php echo admin_url( "post-new.php?post_type=ele-product-template" );?>"><?php _e('Add Single Product Template', 'kadence-woocommerce-elementor-pro'); ?></a>
			<?php 
				$post_loop = null; 
				$post_loop = new WP_Query();
				$post_loop->query(array(
					'orderby' => 'DESC',
					'order' => 'date',
					'post_type' => 'ele-p-arch-template',
					'posts_per_page' => '-1'));
				if ( $post_loop ) : ?>
			<div class="kwt-templates-list kwt-archives kwt-table kwt-clearfix">
				<div class="kwt-table-title">
					<h3>
						<?php _e('Product Archive Templates', 'kadence-woocommerce-elementor-pro'); ?>
					</h3>
				</div>
				<div class="kwt_table_body kwt-clearfix">
					<div class="kwt-table-header kwt-clearfix">
						<div class="kwt-table-column kwt_column_01"><?php _e('Name', 'kadence-woocommerce-elementor-pro'); ?></div>
						<div class="kwt-table-column kwt_column_02"><?php _e('Actions', 'kadence-woocommerce-elementor-pro'); ?></div>
					</div>

					<?php 
			 		if (!$post_loop->have_posts()) : ?>
				        <div class="kwt-no-temlplates">
							<?php echo __('No Templates found. Please add a new one.', 'kadence-woocommerce-elementor-pro'); ?>
						</div>
	       			<?php 
        			endif;

					while ( $post_loop->have_posts() ) : $post_loop->the_post();
					global $post;
					?>
						<div class="kwt_table_content kwt_table_row kwt-clearfix">
							<div class="kwt-table-column kwt_column_01"><a href="<?php echo esc_url(get_edit_post_link($post->ID));?>"><?php echo get_the_title();?></a></div>
							<div class="kwt-table-column kwt_column_02">
								<a class="kwt-edit-template kwt-button kwt-button kwt-is-success" href="<?php echo get_edit_post_link($post->ID);?>"><?php echo __('Edit Template', 'kadence-woocommerce-elementor-pro');?></a>
								<a class="kwt-delete-template kwt-button kwt-button kwt-is-danger" href="<?php echo get_delete_post_link($post->ID);?>"><?php echo __('Delete Template', 'kadence-woocommerce-elementor-pro');?></a>
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			</div>

			<?php endif; 
			wp_reset_query();
			?>
			<a class="kwt-button kwt-is-primary kt-product-archive" href="<?php echo admin_url( "post-new.php?post_type=ele-p-arch-template" );?>"><?php _e('Add Product Archive Template', 'kadence-woocommerce-elementor-pro'); ?></a>
			<?php 
				$post_loop = null; 
				$post_loop = new WP_Query();
				$post_loop->query(array(
					'orderby' => 'DESC',
					'order' => 'date',
					'post_type' => 'ele-p-loop-template',
					'posts_per_page' => '50',
				) );
				if ( $post_loop ) : ?>
			<div class="kwt-templates-list kwt-archives kwt-table kwt-clearfix">
				<div class="kwt-table-title">
					<h3>
						<?php _e('Product Archive Loop Content Templates', 'kadence-woocommerce-elementor-pro'); ?>
					</h3>
				</div>
				<div class="kwt_table_body kwt-clearfix">
					<div class="kwt-table-header kwt-clearfix">
						<div class="kwt-table-column kwt_column_01"><?php _e('Name', 'kadence-woocommerce-elementor-pro'); ?></div>
						<div class="kwt-table-column kwt_column_02"><?php _e('Actions', 'kadence-woocommerce-elementor-pro'); ?></div>
					</div>

					<?php 
			 		if (!$post_loop->have_posts()) : ?>
				        <div class="kwt-no-temlplates">
							<?php echo __('No Templates found. Please add a new one.', 'kadence-woocommerce-elementor-pro'); ?>
						</div>
	       			<?php 
        			endif;

					while ( $post_loop->have_posts() ) : $post_loop->the_post();
					global $post;
					?>
						<div class="kwt_table_content kwt_table_row kwt-clearfix">
							<div class="kwt-table-column kwt_column_01"><a href="<?php echo esc_url(get_edit_post_link($post->ID));?>"><?php echo get_the_title();?></a></div>
							<div class="kwt-table-column kwt_column_02">
								<a class="kwt-edit-template kwt-button kwt-button kwt-is-success" href="<?php echo get_edit_post_link($post->ID);?>"><?php echo __('Edit Template', 'kadence-woocommerce-elementor-pro');?></a>
								<a class="kwt-delete-template kwt-button kwt-button kwt-is-danger" href="<?php echo get_delete_post_link($post->ID);?>"><?php echo __('Delete Template', 'kadence-woocommerce-elementor-pro');?></a>
							</div>
						</div>
					<?php endwhile; ?>
				</div>
			</div>

			<?php endif; 
			wp_reset_query();
			?>
			<a class="kwt-button kwt-is-primary kt-product-archive" href="<?php echo admin_url( "post-new.php?post_type=ele-p-loop-template" );?>"><?php _e('Add Product Loop Content Template', 'kadence-woocommerce-elementor-pro'); ?></a>
			<?php 
			$post_loop = null; 
			$post_loop = new WP_Query();
			$post_loop->query(array(
				'orderby' => 'DESC',
				'order' => 'date',
				'post_type' => 'ele-check-template',
				'posts_per_page' => '-1'));
			if ( $post_loop ) : ?>
			<div class="kwt-templates-list kwt-checkout kwt-table kwt-clearfix">
				<div class="kwt-table-title">
					<h3>
						<?php _e('Checkout Templates', 'kadence-woocommerce-elementor-pro'); ?>
					</h3>
				</div>
				<div class="kwt_table_body kwt-clearfix">
					<div class="kwt-table-header kwt-clearfix">
						<div class="kwt-table-column kwt_column_01"><?php _e('Name', 'kadence-woocommerce-elementor-pro'); ?></div>
						<div class="kwt-table-column kwt_column_02"><?php _e('Actions', 'kadence-woocommerce-elementor-pro'); ?></div>
					</div>

				<?php 
			 	if (!$post_loop->have_posts()) : ?>
			        <div class="kwt-no-temlplates">
						<?php echo __('No Templates found. Please add a new one.', 'kadence-woocommerce-elementor-pro'); ?>
					</div>
		       <?php 
	        	endif;
		
				while ( $post_loop->have_posts() ) : $post_loop->the_post();
				global $post;
				?>
					<div class="kwt_table_content kwt_table_row kwt-clearfix">
						<div class="kwt-table-column kwt_column_01"><a href="<?php echo esc_url(get_edit_post_link($post->ID));?>"><?php echo get_the_title();?></a></div>
						<div class="kwt-table-column kwt_column_02">
							<a class="kwt-edit-template kwt-button kwt-button kwt-is-success" href="<?php echo get_edit_post_link($post->ID);?>"><?php echo __('Edit Template', 'kadence-woocommerce-elementor-pro');?></a>
							<a class="kwt-delete-template kwt-button kwt-button kwt-is-danger" href="<?php echo get_delete_post_link($post->ID);?>"><?php echo __('Delete Template', 'kadence-woocommerce-elementor-pro');?></a>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		</div>

		<?php endif; 
		wp_reset_query();
		?>
		<a class="kwt-button kwt-is-primary kt-product-archive" href="<?php echo admin_url( "post-new.php?post_type=ele-check-template" );?>"><?php _e('Add Checkout Template', 'kadence-woocommerce-elementor-pro'); ?></a>
	</div>
	<?php 
	}
	/**
	 * Don't display the elementor templates on the frontend for non edit_posts capable users.
	 *
	 * @since  1.0.0
	 */
	public function block_pro_template_frontend() {
		if ( is_singular( 'ele-p-arch-template' ) && ! current_user_can( 'edit_posts' ) ) {
			wp_redirect( site_url(), 301 );
			die;
		} else if ( is_singular( 'ele-check-template' ) && ! current_user_can( 'edit_posts' ) ) {
			wp_redirect( site_url(), 301 );
			die;
		} else if ( is_singular( 'ele-p-loop-template' ) && ! current_user_can( 'edit_posts' ) ) {
			wp_redirect( site_url(), 301 );
			die;
		}
	}
	/**
	 * Tells woocommerce it's a woocommerce page.
	 *
	 * @since  1.0.9
	 *
	 * @param Bool $is_woocommerce bool about if woocommerce.
	 */
	public function load_woocommerce( $is_woocommerce ) {

		return true;
	}

	/**
	 * Single template function which will choose our template
	 *
	 * @since  1.0.5
	 *
	 * @param  String $single_template Single template.
	 */
	public function pro_load_loop_template( $single_template ) {

		global $post;

		if ( 'ele-p-loop-template' == $post->post_type ) {
			add_filter( 'is_woocommerce', array( $this, 'load_woocommerce' ) );

			return KT_WOOELE_PRO_PATH . '/templates/product-loop-preview.php';
		}

		return $single_template;
	}

	/**
	 * Single template function which will choose our template
	 *
	 * @since  1.0.1
	 *
	 * @param  String $single_template Single template.
	 */
	function pro_load_fullwidth_template( $single_template ) {

		global $post;

		if ( 'ele-p-arch-template' == $post->post_type ) {
			add_filter( 'is_woocommerce', array( $this, 'load_woocommerce' ) );
			$elementor_2_0_header_footer = ELEMENTOR_PATH . '/modules/page-templates/templates/header-footer.php';

			if ( file_exists( $elementor_2_0_header_footer ) ) {
				return $elementor_2_0_header_footer;
			} else {
				return ELEMENTOR_PATH . '/includes/page-templates/header-footer.php';
			}
		}

		return $single_template;
	}
	/**
	 * Single template function which will choose our template
	 *
	 * @since  1.0.1
	 *
	 * @param  String $single_template Single template.
	 */
	function pro_load_checkout_template( $single_template ) {

		global $post;

		if ( 'ele-check-template' == $post->post_type ) {
			add_filter( 'is_woocommerce', array( $this, 'load_woocommerce' ) );
			return KT_WOOELE_PRO_PATH . 'templates/checkout-preview-fullwidth.php';
		}

		return $single_template;
	}

}

Kadence_Woocommerce_Elementor_Pro_Admin::get_instance();
