<?php
defined( 'ABSPATH' ) or exit;

/**
 * Class Kadence_Product_Archive_Elementor
 */
class Kadence_Product_Archive_Elementor {

	/**
	 * @var null
	 */
	private static $instance = null;

	/**
	* Instance Control
	*/
	public static function get_instance() {
		if ( is_null(  self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Constructor
	 */
	public function __construct() {

		// Replace main template
		add_filter(	'template_include', array( $this, 'archive_template_loader' ), 50 );

		// Add Elementor
		add_action( 'kadence_woocommerce_archive_builder', array( $this, 'archive_template' ) );

		// Scripts and styles.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

	}
	public function archive_template_loader( $template ) {
		if ( is_embed() ) {
			return $template;
		}
		if ( kadence_woo_ele_archive_template_enabled() ) {
			remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
			$t_slug = get_page_template_slug( get_kadence_woo_ele_archive_builder_id() );

			if ( $t_slug == 'elementor_header_footer' ) {
				$template = KT_WOOELE_PRO_PATH  . 'templates/archive-product-elementor-fullwidth.php';
			} else if( $t_slug == 'elementor_canvas' ) {
				$template = KT_WOOELE_PRO_PATH  . 'templates/archive-product-elementor-canvas.php';
			} else {
				$template = KT_WOOELE_PRO_PATH . 'templates/archive-product-elementor.php';
			}
		}
		return $template;
	}

	public static function archive_template() {
		echo Kadence_Woocommerce_Elementor_Pro::$elementor_instance->frontend->get_builder_content_for_display( get_kadence_woo_ele_archive_builder_id() );
	}
	/**
	 * Enqueue styles and scripts.
	 */
	public function enqueue_scripts() {
		if ( kadence_woo_ele_archive_template_enabled() ) {
			//wp_enqueue_style( 'kt-woo-ele-pro-style', KT_WOOELE_PRO_URL . 'assets/css/kadence-woocommerce-elementor-pro.css', array(), KT_WOOELE_PRO_VERSION );
			if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
				if ( class_exists( '\Elementor\Plugin' ) ) {
					$elementor = \Elementor\Plugin::instance();
					if ( $elementor && isset( $elementor->frontend ) ) {
						if ( method_exists( $elementor->frontend, 'enqueue_scripts' ) ) {
							$elementor->frontend->enqueue_scripts();
						}
					}
				}

				if ( class_exists( '\ElementorPro\Plugin' ) ) {
					$elementor_pro = \ElementorPro\Plugin::instance();
					if ( $elementor_pro && method_exists( $elementor_pro, 'enqueue_styles' ) ) {
						$elementor_pro->enqueue_styles();
					}
				}
				if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
					$css_file = new \Elementor\Core\Files\CSS\Post( get_kadence_woo_ele_archive_builder_id() );
					if ( $css_file && method_exists( $css_file, 'enqueue' ) ) {
						$css_file->enqueue();
					}
				}
			}
		}
	}

}
Kadence_Product_Archive_Elementor::get_instance();
