<?php
/**
 * Elementor widget control
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * Class Kadence_Woocommerce_Elementor_Pro_Widget_Control
 */
class Kadence_Woocommerce_Elementor_Pro_Widget_Control {

	/**
	 * Instance Control
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Constructor
	 */
	public function __construct() {
		// Add widgets.
		add_action( 'elementor/widgets/widgets_registered', array( $this, 'widgets_registered' ) );
		//add_action( 'elementor/elements/categories_registered', array( $this, 'add_widget_categories' ) );
		add_action( 'elementor/frontend/after_register_scripts', array( $this, 'support_scripts' ), 100 );

	}
	/**
	 * Support scripts.
	 */
	public function support_scripts() {
		if ( Kadence_Woocommerce_Elementor_Pro::$elementor_instance->preview->is_preview_mode() ) {
			wp_register_script( 'kt-woo-ele-checkout', KT_WOOELE_PRO_URL . 'assets/js/kadence-woocommerce-elementor-checkout.js', array( 'jquery', 'selectWoo' ), KT_WOOELE_PRO_VERSION, true );
		}

	}
	/**
	 * Add category for product widgets.
	 *
	 * @param object $elements_manager the elements manager.
	 */
	public function add_widget_categories( $elements_manager ) {
		$elements_manager->add_category(
			'product-checkout',
			array(
				'title' => __( 'Checkout Elements', 'kadence-woocommerce-elementor-pro' ),
				'icon'  => 'eicon-woocommerce',
			),
			1
		);
		$elements_manager->add_category(
			'product-archive',
			array(
				'title' => __( 'Product Archive Elements', 'kadence-woocommerce-elementor-pro' ),
				'icon'  => 'eicon-woocommerce',
			),
			1
		);
	}
	/**
	 * Widget registration.
	 */
	public function widgets_registered() {
		$kadence_wooele_elements = array(
			'product-archive-mainloop',
			'product-archive-title',
			'product-archive-description',
			'product-loop-image-element',
			'product-loop-title-element',
			'product-loop-excerpt-element',
			'product-loop-rating-element',
			'product-loop-price-element',
			'product-loop-button-element',
			'product-loop-custom-element',
			'checkout-billing',
			'checkout-shipping',
			'checkout-additional',
			'checkout-payment',
			'checkout-review',
		);
		foreach ( $kadence_wooele_elements as $element_name ) {
			require_once KT_WOOELE_PRO_PATH . 'inc/elementor-widgets/' . $element_name . '.php';
		}
	}

}
Kadence_Woocommerce_Elementor_Pro_Widget_Control::get_instance();
