<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Checkout_Order Review
 *
 */
class Checkout_Review_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'checkout-review';
	}

	public function get_title() {
		return __( 'Checkout: Order Review', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-table';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Checkout Order Review', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the order review for checkout', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			array(
				'label' => __( 'Heading Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Heading Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'Heading Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} h3#order_review_heading',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_thead_style',
			array(
				'label' => __( 'Table Head Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'thead_color',
			[
				'label'     => __( 'Table Head Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table thead' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'thead_typography',
				'label'     => __( 'Table Head Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .woocommerce-checkout-review-order-table thead th',
			)
		);
		$this->add_control(
			'thead_background',
			[
				'label'     => __( 'Table Head Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table thead' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'thead_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .woocommerce-checkout-review-order-table thead tr th',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'thead_padding',
			[
				'label' => __( 'Table Head Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table thead tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_trow_style',
			array(
				'label' => __( 'Table Body Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'trow_color',
			[
				'label'     => __( 'Table Body Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tbody' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'trow_typography',
				'label'     => __( 'Table Body Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .woocommerce-checkout-review-order-table tbody',
			)
		);
		$this->add_control(
			'trow_odd_background',
			[
				'label'     => __( 'Table Odd Rows Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tbody tr:nth-child(odd)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'trow_even_background',
			[
				'label'     => __( 'Table Even Rows Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tbody tr:nth-child(even)' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'trow_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .woocommerce-checkout-review-order-table tbody tr td',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'trow_padding',
			[
				'label' => __( 'Table Body Item Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tbody tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_tfoot_style',
			array(
				'label' => __( 'Table Footer Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'tfoot_color',
			[
				'label'     => __( 'Table Footer Text Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'tfoot_typography',
				'label'     => __( 'Table Footer Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot',
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'tfoot_th_typography',
				'label'     => __( 'Table Footer Header Cell Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot th',
			)
		);
		$this->add_control(
			'tfoot_td_background',
			[
				'label'     => __( 'Table Footer Column Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr td' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'tfoot_th_background',
			[
				'label'     => __( 'Table Footer Header Column Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr th' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'tfoot_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr td, {{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr th',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'tfoot_padding',
			[
				'label' => __( 'Table Footer Item Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr td, {{WRAPPER}} .woocommerce-checkout-review-order-table tfoot tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section();

	}


	protected function render() {
		//$settings = $this->get_settings_for_display();
		if( is_checkout() ) {

        		?>
        		<h3 id="order_review_heading" style="float:none; width:auto; padding-left:0; padding-right: 0;"><?php _e( 'Your order', 'kadence-woocommerce-elementor-pro' ); ?></h3>
        		<div id="order_review" class="woocommerce-checkout-review-order">
	        		<?php
	        		woocommerce_order_review();
	        		?>
        		</div>
        		<?php

	    } else if ( 'ele-check-template' == get_post_type() ) {
			$checkout = WC()->checkout();
			if ( WC()->cart->is_empty() ) {
				echo 'empty';
			}
        		?>
        		<h3 id="order_review_heading" style="float:none; width:auto;"><?php _e( 'Your order', 'kadence-woocommerce-elementor-pro' ); ?></h3>
        		<div id="order_review" class="woocommerce-checkout-review-order">
	        		<?php
	        		woocommerce_order_review();
	        		?>
        		</div>
        		<?php
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Checkout_Review_Element());
