<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Checkout_Shipping
 *
 */
class Checkout_Shipping_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'checkout-shipping';
	}

	public function get_title() {
		return __( 'Checkout: Shipping Form', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Checkout Shipping', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the shipping fields for checkout', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			array(
				'label' => __( 'Heading Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Heading Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'title_typography',
				'label'     => __( 'Heading Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} h3',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_label_style',
			array(
				'label' => __( 'Field Label Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'label_color',
			[
				'label'     => __( 'Field Label Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'label_typography',
				'label'     => __( 'Field Label Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .form-row label',
			)
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_input_style',
			array(
				'label' => __( 'Field Input Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'input_typography',
				'label'     => __( 'Field Input Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .form-row input.input-text',
			)
		);
		$this->add_control(
			'input_placeholder_color',
			[
				'label'     => __( 'Field Placeholder Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text::placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input.input-text::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input.input-text::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .form-row input.input-text:-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);
		$this->start_controls_tabs( 'tabs_input_style' );

		$this->start_controls_tab(
			'tab_input_normal',
			[
				'label' => __( 'Normal', 'kadence-woocommerce-elementor-pro' ),
			]
		);
		$this->add_control(
			'input_color',
			[
				'label'     => __( 'Field Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'input_background',
			[
				'label'     => __( 'Field Input Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'input_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row input.input-text',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'input_border_radius',
			[
				'label' => __( 'Input Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_box_shadow',
				'selector' => '{{WRAPPER}} .form-row input.input-text',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_input_focus',
			[
				'label' => __( 'Focus', 'kadence-woocommerce-elementor-pro' ),
			]
		);
		$this->add_control(
			'input_focus_color',
			[
				'label'     => __( 'Field Input Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text:focus' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'input_background_focus',
			[
				'label'     => __( 'Field Input Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text:focus' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'input_border_focus',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row input.input-text:focus',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'input_border_radius_focus',
			[
				'label' => __( 'Input Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text:focus' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'input_box_shadow_focus',
				'selector' => '{{WRAPPER}} .form-row input.input-text:focus',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		

		$this->add_responsive_control(
			'input_padding',
			[
				'label' => __( 'Field Input Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row input.input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_select_style',
			array(
				'label' => __( 'Field Select Style', 'kadence-woocommerce-elementor-pro' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'      => 'select_typography',
				'label'     => __( 'Field Select Typography', 'kadence-woocommerce-elementor-pro' ),
				'selector'  => '{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection,  {{WRAPPER}} .form-row .select2-container .select2-selection .select2-selection__rendered',
			)
		);
		$this->start_controls_tabs( 'tabs_select_style' );

		$this->start_controls_tab(
			'tab_select_normal',
			[
				'label' => __( 'Normal', 'kadence-woocommerce-elementor-pro' ),
			]
		);
		$this->add_control(
			'select_color',
			[
				'label'     => __( 'Field Select Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection .select2-selection__rendered' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'select_background',
			[
				'label'     => __( 'Field Select Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'select_border',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'select_border_radius',
			[
				'label' => __( 'Select Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'select_box_shadow',
				'selector' => '{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_select_focus',
			[
				'label' => __( 'Focus', 'kadence-woocommerce-elementor-pro' ),
			]
		);

		$this->add_control(
			'select_color_focus',
			[
				'label'     => __( 'Field Select Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row select:focus, {{WRAPPER}} .form-row .select2-container.select2-container--open .select2-selection .select2-selection__rendered' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'select_background_focus',
			[
				'label'     => __( 'Field Select Background Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form-row select:focus, {{WRAPPER}} .form-row .select2-container.select2-container--open .select2-selection' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'select_border_focus',
				'placeholder' => '1px',
				'default' => '0',
				'selector' => '{{WRAPPER}} .form-row select:focus, {{WRAPPER}} .form-row .select2-container.select2-container--open .select2-selection',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'select_border_radius_focus',
			[
				'label' => __( 'Select Border Radius', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row select:focus, {{WRAPPER}} .form-row .select2-container.select2-container--open .select2-selection' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'select_box_shadow_focus',
				'selector' => '{{WRAPPER}} .form-row select:focus, {{WRAPPER}} .form-row .select2-container.select2-container--open .select2-selection',
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->add_responsive_control(
			'select_padding',
			[
				'label' => __( 'Field Select Padding', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .form-row select, {{WRAPPER}} .form-row .select2-container .select2-selection' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing: content-box;',
					'{{WRAPPER}} .form-row .select2-container .select2-selection .select2-selection__arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} 0; box-sizing: content-box;',
				],
				'separator' => 'before',
			]
		);
		
		$this->end_controls_section();

	}


	protected function render() {
		//$settings = $this->get_settings_for_display();
		if( is_checkout() ) {
			$checkout = WC()->checkout();
        	if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
        		<div class="woocommerce-shipping-fields">
				<?php if ( true === WC()->cart->needs_shipping_address() ) : ?>

					<h3 id="ship-to-different-address">
						<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
							<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" <?php checked( apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 1 : 0 ), 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" /> <span><?php _e( 'Ship to a different address?', 'kadence-woocommerce-elementor-pro' ); ?></span>
						</label>
					</h3>

					<div class="shipping_address">

						<?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>

						<div class="woocommerce-shipping-fields__field-wrapper">
							<?php
								$fields = $checkout->get_checkout_fields( 'shipping' );

								foreach ( $fields as $key => $field ) {
									if ( isset( $field['country_field'], $fields[ $field['country_field'] ] ) ) {
										$field['country'] = $checkout->get_value( $field['country_field'] );
									}
									woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
								}
							?>
						</div>

						<?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>

					</div>

				<?php endif; ?>
			</div>
			<?php
        	endif;
		} elseif ( 'ele-check-template' == get_post_type() ) {
			$checkout = WC()->checkout();
			if ( sizeof( $checkout->checkout_fields ) > 0 ) : ?>
				<div class="woocommerce-shipping-fields elementor-previewing-woo-check">

					<h3 id="ship-to-different-address">
						<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
							<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" <?php checked( 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" /> <span><?php _e( 'Ship to a different address?', 'kadence-woocommerce-elementor-pro' ); ?></span>
						</label>
					</h3>

					<div class="shipping_address">

						<?php do_action( 'woocommerce_before_checkout_shipping_form', $checkout ); ?>

						<div class="woocommerce-shipping-fields__field-wrapper">
							<?php
								$fields = $checkout->get_checkout_fields( 'shipping' );

								foreach ( $fields as $key => $field ) {
									if ( isset( $field['country_field'], $fields[ $field['country_field'] ] ) ) {
										$field['country'] = $checkout->get_value( $field['country_field'] );
									}
									woocommerce_form_field( $key, $field, $checkout->get_value( $key ) );
								}
							?>
						</div>

						<?php do_action( 'woocommerce_after_checkout_shipping_form', $checkout ); ?>

					</div>
			</div>
			<?php
        	endif;
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Checkout_Shipping_Element());
