<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Elementor Element Product Main Loop
 *
 */
class Product_Archive_Mainloop_Element extends \Elementor\Widget_Base {

	public function get_name() {
		return 'archive-mainloop';
	}

	public function get_title() {
		return __( 'Product Archive: Mainloop', 'kadence-woocommerce-elementor-pro' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return array( 'woocommerce-elements' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Archive Mainloop', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the archive main loop which means it can have pagination', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);

		$this->add_control(
			'product_archive_columns',
			[
				'label'        => __( 'Product Columns', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => __( 'Default', 'kadence-woocommerce-elementor-pro' ),
					'1' => __( '1', 'kadence-woocommerce-elementor-pro' ),
					'2' => __( '2', 'kadence-woocommerce-elementor-pro' ),
					'3' => __( '3', 'kadence-woocommerce-elementor-pro' ),
					'4' => __( '4', 'kadence-woocommerce-elementor-pro' ),
					'5' => __( '5', 'kadence-woocommerce-elementor-pro' ),
					'6' => __( '6', 'kadence-woocommerce-elementor-pro' ),
				],
				'default'      => 'default',
			]
		);
		$this->add_control(
			'product_count_ordering',
			[
				'label'        => __( 'Results Count and Ordering', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => __( 'Show Default', 'kadence-woocommerce-elementor-pro' ),
					'hide' => __( 'Hide', 'kadence-woocommerce-elementor-pro' ),
					'force' => __( 'Force Show', 'kadence-woocommerce-elementor-pro' ),
				],
				'default'      => 'default',
			]
		);
		$this->add_control(
			'product_pagination',
			[
				'label'        => __( 'Product Pagination', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'default' => __( 'Show Default', 'kadence-woocommerce-elementor-pro' ),
					'hide' => __( 'Hide', 'kadence-woocommerce-elementor-pro' ),
					'force' => __( 'Force Show', 'kadence-woocommerce-elementor-pro' ),
				],
				'default'      => 'default',
			]
		);
		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( is_product_taxonomy() || is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
			if( isset( $settings['product_archive_columns'] ) && ! empty( $settings['product_archive_columns'] ) && $settings['product_archive_columns'] != 'default' ) {
				wc_set_loop_prop( 'columns', absint( $settings['product_archive_columns'] ) );
			}
			if( isset( $settings['product_count_ordering'] ) &&  ( 'hide' == $settings['product_count_ordering'] || 'force' == $settings['product_count_ordering'] ) ) {
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
				remove_action( 'woocommerce_before_shop_loop', 'ascend_woo_loop_top', 20 );
				remove_action( 'woocommerce_before_shop_loop', 'pinnacle_woo_archive_top', 20 );
				// if ( class_exists( 'Kadence\Theme' ) ) {
				// 	$kadence_class = new Kadence\Theme();
				// 	remove_action( 'woocommerce_before_shop_loop', array( $kadence_class->components['woocommerce'], 'archive_loop_top' ), 20 );
				// }
			}
			if ( isset( $settings['product_pagination'] ) &&  ( 'hide' == $settings['product_pagination'] || 'force' == $settings['product_pagination'] ) ) {
				remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
			}
			if ( have_posts() ) {

				/**
				 * woocommerce_before_shop_loop hook.
				 *
				 * @hooked wc_print_notices - 10
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action( 'woocommerce_before_shop_loop' );
				if( isset( $settings['product_count_ordering'] ) && 'force' == $settings['product_count_ordering'] ) {
					echo '<div class="clearfix kt_shop_top_container">';
						woocommerce_result_count();
						if ( function_exists( 'kt_woocommerce_page_title_toggle') ) {
							kt_woocommerce_page_title_toggle();
						}
						woocommerce_catalog_ordering();
		  			echo '</div>';
				}

				woocommerce_product_loop_start();

					if ( isset( $settings['product_archive_columns'] ) && ! empty( $settings['product_archive_columns'] ) && $settings['product_archive_columns'] != 'default' ) {
						wc_set_loop_prop( 'columns', absint( $settings['product_archive_columns'] ) );
					}
					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 *
							 * @hooked WC_Structured_Data::generate_product_data() - 10
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}
				woocommerce_product_loop_end();

					/**
				 * woocommerce_after_shop_loop hook.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
				if ( isset($settings['product_pagination'] ) && 'force' ==$settings['product_pagination'] ) {
					woocommerce_pagination();
				}
			
			} else {
				/**
				 * Hook: woocommerce_no_products_found.
				 *
				 * @hooked wc_no_products_found - 10
				 */
				do_action( 'woocommerce_no_products_found' );

			}
	    } else if ( 'ele-p-arch-template' == get_post_type() ) {
	    	if ( isset( $settings['product_archive_columns'] ) && ! empty( $settings['product_archive_columns'] ) && $settings['product_archive_columns'] != 'default' ) {
				$columns = $settings['product_archive_columns'];
			} else {
				$columns = wc_get_default_products_per_row();
			}
			$limit = apply_filters( 'loop_shop_per_page', wc_get_default_products_per_row() * wc_get_default_product_rows_per_page() );
	    	echo do_shortcode( '[products limit="' . esc_attr( $limit ) . '" columns="' . esc_attr( $columns ) . '" orderby="menu_order" order="ASC" visibility="visible"]' );
	    } else {
	    	echo  __( 'This element is not designed for this post type', 'kadence-woocommerce-elementor-pro' );
	    }
	}

	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Product_Archive_Mainloop_Element());
