<?php
/**
 * Build Elementor Element
 *
 * @package Kadence Woocommerce Elementor Pro.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Element Product Loop Rating
 */
class Product_Loop_Rating_Element extends \Elementor\Widget_Base {
	/**
	 * Get Element name.
	 */
	public function get_name() {
		return 'product-loop-rating';
	}
	/**
	 * Get Element Title.
	 */
	public function get_title() {
		return __( 'Product Loop: Rating', 'kadence-woocommerce-elementor-pro' );
	}
	/**
	 * Get Element Icon.
	 */
	public function get_icon() {
		return 'eicon-product-rating';
	}
	/**
	 * Get Element Categories.
	 */
	public function get_categories() {
		return array( 'woocommerce-elements' );
	}
	/**
	 * Element register.
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			array(
				'label' => __( 'Product Loop Rating', 'kadence-woocommerce-elementor-pro' ),
			)
		);
		$this->add_control(
			'important_note',
			array(
				'label' => __( 'Element Information', 'kadence-woocommerce-elementor-pro' ),
				'show_label' => false,
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => __( 'This outputs the product rating.', 'kadence-woocommerce-elementor-pro' ),
				'content_classes' => 'kadence-woo-ele-info',
			)
		);
		$this->add_control(
			'rating_link',
			[
				'label' => __( 'Rating Link', 'kadence-woocommerce-elementor-pro' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'product',
				'options' => [
					'product' => __( 'Link to Product', 'kadence-woocommerce-elementor-pro' ),
					'none'    => __( 'No Link', 'kadence-woocommerce-elementor-pro' ),
				],
			]
		);
		$this->add_control(
			'rating_color',
			array(
				'label'     => __( 'Rating Color', 'kadence-woocommerce-elementor-pro' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .star-rating span:before' => 'color: {{VALUE}};',
				],
			)
		);
		$this->add_responsive_control(
			'rating_padding',
			[
				'label' => __( 'Rating Padding', 'kadence-woocommerce-elementor' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .kadence-ele-builder-loop-rating-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'rating_align',
			array(
				'label'        => __( 'Rating Alignment', 'kadence-woocommerce-elementor-pro' ),
				'type'         => \Elementor\Controls_Manager::CHOOSE,
				'options'      => [
					'left'   => [
						'title' => __( 'Left', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'kadence-woocommerce-elementor-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'kt-woo-rating-align-',
				'default'      => 'center',
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Element render.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( 'ele-p-loop-template' == get_post_type() ) {
			echo '<ul class="products">';
			echo '<li class="product">';
			echo '<span class="kadence-ele-builder-loop-rating-wrap kadence-ele-builder-loop-rating-link">';
				echo '<div class="star-rating"><span style="width:80%">Rated <strong class="rating">5.00</strong> out of 5</span></div>';
			echo '</span>';
			echo '</li>';
			echo '</ul>';
		} elseif ( 'product' == get_post_type() ) {
			if ( 'product' === $settings['rating_link'] ) {
				global $product;
				$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
				echo '<a href="' . esc_url( $link ) . '" class="kadence-ele-builder-loop-rating-wrap kadence-ele-builder-loop-rating-link">';
			} else {
				echo '<span class="kadence-ele-builder-loop-rating-wrap">';
			}
				woocommerce_template_loop_rating();
			if ( 'product' === $settings['rating_link'] ) {
				echo '</a>';
			} else {
				echo '</span>';
			}
		}
	}
	/**
	 * Element content template.
	 */
	protected function _content_template() {}
}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Product_Loop_Rating_Element() );
