<?php
defined( 'ABSPATH' ) or exit;

/**
 * Product Loop Class
 *
 * @param string|array           $class      One or more classes to add to the class list.
 * @param int|WP_Post|WC_Product $product_id Product ID or product object.
 */
function kadence_woo_ele_product_class( $class = null, $product_id = null ) {
	echo 'class="' . esc_attr( join( ' ', apply_filters( 'kadence_woo_ele_product_loop_classes', wc_get_product_class( $class, $product_id ) ) ) ) . '"';
}

function kadence_woo_ele_product_loop_short_description() {
	add_filter( 'kadence_archive_woocommerce_short_description', 'wptexturize', 10);
	add_filter( 'kadence_archive_woocommerce_short_description', 'wpautop', 10);
	add_filter( 'kadence_archive_woocommerce_short_description', 'shortcode_unautop', 10);
	add_filter( 'kadence_archive_woocommerce_short_description', 'do_shortcode', 11 );
}
add_action( 'init', 'kadence_woo_ele_product_loop_short_description' );

/**
 * Checks if Woo Ele Builder is running
 *
 */
function kadence_woo_ele_archive_template_enabled() {
	$status = false;
	if ( is_product_taxonomy() ) {
		$cat_term_id = get_queried_object()->term_id;
		$meta = get_option( 'kwetb_archive' );
		if ( empty( $meta ) ) { 
			$meta = array();
		}
		if ( ! is_array( $meta ) ) {
			$meta = (array) $meta;
		}
		$meta = isset( $meta[ $cat_term_id ] ) ? $meta[ $cat_term_id ] : array();
		if( isset( $meta['kwetb_archive_template'] ) ) {
			$new_template = $meta['kwetb_archive_template'];
		}
		if ( is_product_category() ) {
			$category_default = Kadence_Woocommerce_Elementor_Pro::get_default_category_setting();
			if ( isset( $new_template ) && ! empty( $new_template ) && $new_template != 'default' ) {
				$status = true;
			} else if( ! empty( $category_default ) && $category_default != 'default') {
				$status = true;
			}
		} else if ( is_product_tag() ) {
			$tag_default = Kadence_Woocommerce_Elementor_Pro::get_default_tag_setting();
			if ( isset( $new_template ) && ! empty( $new_template ) && $new_template != 'default' ) {
				$status = true;
			} else if( ! empty( $tag_default ) && $tag_default != 'default') {
				$status = true;
			}
		}
	} else if( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
		$shop_default = Kadence_Woocommerce_Elementor_Pro::get_default_shop_setting();
		if( ! empty( $shop_default ) && $shop_default != 'default') {
			$status = true;
		}
	}
	return apply_filters( 'kadence_woo_ele_archive_builder_enabled', $status );
}
function kadence_woo_ele_return_checkout_array( $value, $input ) {
	//if ('billing_country' == $input || 'shipping_country' == $input || 'billing_first_name' == $input ) {
		if(null == $value ){
			$value= 'US';
		}
	//}
	return $value;
}
function kadence_woo_ele_checkout_template_enabled() {
	$status = false;
	if ( is_checkout() ) {
		$checkout_setting = Kadence_Woocommerce_Elementor_Pro::get_default_checkout_setting();
		if( isset( $checkout_setting ) && !empty( $checkout_setting ) && $checkout_setting != 'default' ) {
			$status = true;
		}
	}
	return apply_filters( 'kadence_woo_ele_checkout_builder_enabled', $status );
}
// Gets the ID of template.
function get_kadence_woo_ele_archive_builder_id() {
	$template_id = null;
	if ( is_product_taxonomy() ) {
		$cat_term_id = get_queried_object()->term_id;
		$meta = get_option( 'kwetb_archive' );
		if ( empty( $meta ) ) { 
			$meta = array();
		}
		if ( ! is_array( $meta ) ) {
			$meta = (array) $meta;
		}
		$meta = isset( $meta[ $cat_term_id ] ) ? $meta[ $cat_term_id ] : array();
		if( isset( $meta['kwetb_archive_template'] ) ) {
			$new_template = $meta['kwetb_archive_template'];
		}
		if ( isset( $new_template ) && ! empty( $new_template ) && $new_template != 'default' ) {
			$template_id = $new_template;
		} else if ( is_product_category() ) {

			$template_id = Kadence_Woocommerce_Elementor_Pro::get_default_category_setting();

		} else if ( is_product_tag() ) {

			$template_id = Kadence_Woocommerce_Elementor_Pro::get_default_tag_setting();
		}
	} else if( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) ) {
		$template_id = Kadence_Woocommerce_Elementor_Pro::get_default_shop_setting();
	}
	return apply_filters( 'kadence_archive_product_elementor_template', $template_id );
}


// function kadence_woo_ele_product_template_enabled() {
// 	$status = false;
// 	if ( is_product() ) {
// 		global $post;
// 		$single_product_default = Kadence_Woocommerce_Elementor::get_default_single_setting();
// 		$custom_template = get_post_meta( $post->ID,'_kt_woo_ele_product_template', true );
// 		if( isset( $custom_template ) && !empty( $custom_template ) && $custom_template != 'default' && $custom_template != 'elementor' ) {
// 			$status = true;
// 		} else if(  isset( $custom_template ) && !empty( $custom_template ) && $custom_template != 'default' && $custom_template == 'elementor' ) {
// 			$status = false;
// 		} else if( ! empty( $single_product_default ) && $single_product_default != 'default') {
// 			$status = true;
// 		}
// 	}
// 	return apply_filters( 'kadence_woo_ele_product_builder_enabled', $status );
// }

// function kt_woo_ele_remove_description_tab( $tabs ) {
// 	unset( $tabs['description'] );      	// Remove the description tab
// 	return $tabs;
// }