<?php
/**
 * Plugin Name:          Kadence Woocommerce Elementor Pro
 * Plugin URI:           https://kadencewp.com/products/woocommerce-elementor/
 * Description:          Elementor for Woocommerce. This plugin adds archive and checkout templates to create custom archive pages as well as for a custom checkout page.
 * Version:              1.1.9
 * Author:               Kadence WP
 * Author URI:           https://kadencewp.com/
 * License:              GPLv2 or later
 * Text Domain:          kadence-woocommerce-elementor-pro
 * WC requires at least: 3.6.0
 * WC tested up to:      9.1.2
 *
 * @package Kadence Woocommerce Elementor Pro
 */

/**
 * Main Plugin class.
 */
class Kadence_Woocommerce_Elementor_Pro {

	/**
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Array to hold returns for category check.
	 *
	 * @var array
	 */
	public static $category_final_id = array();

	/**
	 * Instance of Elementor Frontend class.
	 *
	 * @var \Elementor\Frontend()
	 */
	public static $elementor_instance;

	public $settings;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null(  self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {
			add_action('plugins_loaded', array( $this, 'on_plugins_loaded' ) );
	}
	public function on_plugins_loaded() {

		define( 'KT_WOOELE_PRO_PATH' , realpath( plugin_dir_path(__FILE__) ) . DIRECTORY_SEPARATOR );
		define( 'KT_WOOELE_PRO_URL' , plugin_dir_url(__FILE__) );
		define( 'KT_WOOELE_PRO_VERSION' , '1.1.9' );

		if( ! kadence_wooele_pro_is_woo_active() ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_need_woocommerce' ) );
			return;
		}
		if( ! kadence_wooele_pro_is_ele_active() ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_need_elementor' ) );
			return;
		}
		if( ! kadence_wooele_pro_is_kt_woo_ele_active() ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_need_kt_woo_ele' ) );
			return;
		}

		if ( ! defined( 'ELEMENTOR_VERSION' ) || ! is_callable( 'Elementor\Plugin::instance' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_need_elementor' ) );
			return;
		}

		self::$elementor_instance = Elementor\Plugin::instance();

		$this->includes();

		add_action('init', array( $this, 'on_init' ) );

		// Get translation set up
		load_plugin_textdomain( 'kadence-woocommerce-elementor-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}
	public function on_init() {
		add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts_styles' ) );
		// Get woocommerce working in the editor.
		add_action( 'admin_action_elementor', array( $this, 'wc_fontend_includes' ), 5 );
		// Change status for cat assigned templates.
		add_filter( 'kadence_woo_ele_product_template_enabled', array( $this, 'filter_single_product_template_status' ) );
		// Change status for cat assigned templates.
		add_filter( 'kadence_woo_ele_product_builder_enabled', array( $this, 'filter_single_product_builder_status' ) );
		// return template ID.
		add_filter( 'kadence_product_elementor_template', array( $this, 'filter_single_product_template_id' ) );
	}
	/**
	 * Checks product should be labeled status true.
	 *
	 * @param bool $status true if using elementor.
	 */
	public function filter_single_product_builder_status( $status ) {
		// if already true just send back.
		if ( $status ) {
			return $status;
		}
		if ( is_product() ) {
			global $post;
			$check_cats = Kadence_Woocommerce_Elementor_Pro::check_categories_for_assigned_product_template( $post->ID );
			if ( false !== $check_cats ) {
				$status = true;
			}
		}

		return $status;
	}
	/**
	 * Checks product should be labeled status true.
	 *
	 * @param bool $status true if using a woo template.
	 */
	public function filter_single_product_template_status( $status ) {
		// if already true just send back.
		if ( $status ) {
			return $status;
		}
		if ( is_product() ) {
			global $post;
			$custom_template = get_post_meta( $post->ID, '_kt_woo_ele_product_template', true );
			// if it's set to to the pages elementor return false.
			if ( isset( $custom_template ) && ! empty( $custom_template ) && 'elementor' === $custom_template ) {
				return $status;
			} else {
				$check_cats = Kadence_Woocommerce_Elementor_Pro::check_categories_for_assigned_product_template( $post->ID );
				if ( false !== $check_cats ) {
					$status = true;
				}
			}
		}

		return $status;
	}
	/**
	 * Gets the Template ID from category if needed.
	 *
	 * @param number $template_id the woo ele template id.
	 */
	public function filter_single_product_template_id( $template_id ) {
		if ( is_product() ) {
			global $post;
			$custom_template = get_post_meta( $post->ID, '_kt_woo_ele_product_template', true );
			// Make sure it doesn't have it's own product specific setting.
			if ( ! isset( $custom_template ) || empty( $custom_template ) || 'default' === $custom_template ) {
				$check_cats = Kadence_Woocommerce_Elementor_Pro::check_categories_for_assigned_product_template( $post->ID );
				if ( false !== $check_cats ) {
					$template_id = $check_cats;
				}
			}
		}

		return $template_id;
	}
	/**
	 * Checks product category for assigned template and returns the template ID if true.
	 *
	 * @param number $post_id the product id.
	 */
	public static function check_categories_for_assigned_product_template( $post_id ) {
		if ( ! isset( self::$category_final_id[ $post_id ] ) ) {
			$final_template_id = false;
			$product_cats      = wp_get_post_terms( $post_id, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) );
			$metadata          = get_option( 'kwetb_archive_assign' );
			if ( empty( $metadata ) ) {
				return false;
			}
			if ( ! is_array( $metadata ) ) {
				$metadata = (array) $metadata;
			}
			// Loop through the assigned terms starting with the deepest.
			if ( $product_cats && ! is_wp_error( $product_cats ) ) {
				foreach ( $product_cats as $product_cat ) {
					if ( isset( $metadata[ $product_cat->term_id ] ) ) {
						$meta = $metadata[ $product_cat->term_id ];
						if ( isset( $meta['kwetb_assigned_template'] ) && 'default' !== $meta['kwetb_assigned_template'] ) {
							$final_template_id = $meta['kwetb_assigned_template'];
						}
					}
					if ( false !== $final_template_id ) {
						break;
					}
				}
			}
			self::$category_final_id[ $post_id ] = $final_template_id;
		} else {
			$final_template_id = self::$category_final_id[ $post_id ];
		}
		return $final_template_id;
	}
	/**
	 * Include front end stuff.
	 */
	public function wc_fontend_includes() {
		if ( is_null( WC()->cart ) ) {
			global $woocommerce;
			$session_class = apply_filters( 'woocommerce_session_handler', 'WC_Session_Handler' );
			$woocommerce->session = new $session_class();
			$woocommerce->session->init();

			$woocommerce->cart     = new WC_Cart();
			$woocommerce->customer = new WC_Customer( get_current_user_id(), true );
		}

	}
	public function register_scripts_styles() {
		wp_enqueue_style( 'kadence-woo-ele-templates-pro', KT_WOOELE_PRO_URL . 'assets/css/kadence-woocommerce-elementor-pro.css', array(), KT_WOOELE_PRO_VERSION, 'all' );
	}
	// Add needed files.
	public function includes() {
		// tax meta functions.
		require_once KT_WOOELE_PRO_PATH . 'admin/kadence-taxonomy-meta/class-kadence-taxonomy-meta.php';

		// Admin functions.
		require_once KT_WOOELE_PRO_PATH . 'admin/class-kadence-woocommerce-elementor-pro-admin.php';

		// Kadence Woo Elementor Pro Functions.
		require_once KT_WOOELE_PRO_PATH . 'inc/functions.php';

		// Product Archive Elementor.
		require_once KT_WOOELE_PRO_PATH . 'inc/class-kadence-product-archives-elementor.php';

		// Product content loop Elementor.
		require_once KT_WOOELE_PRO_PATH . 'inc/class-kadence-product-loop-elementor.php';

		// Product Checkout Elementor.
		require_once KT_WOOELE_PRO_PATH . 'inc/class-kadence-checkout-elementor.php';

		// checkout and archive Elementor Widgets.
		require_once KT_WOOELE_PRO_PATH . 'inc/class-kadence-woocommerce-elementor-pro-widget-control.php';

		// Load WPML Compatibility if WPML is installed and activated.
		if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
			require_once KT_WOOELE_PRO_PATH . 'inc/compatibility/class-kadence-woocommerce-elementor-pro-wpml-compatibility.php';
		}

	}
	// Add a notice about php being needed.
	public function admin_notice_need_php() {
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p>'.sprintf( __( 'Kadence Woocommerce Elementor Pro requires PHP version %s+, plugin is currently NOT RUNNING', 'kadence-woocommerce-elementor-pro' ).'</p>', '5.4');
		echo '</div>';
	}
	// Add a notice about woocommerce being needed.
	public function admin_notice_need_woocommerce() {
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p>'.sprintf( __( 'Kadence Woocommerce Elementor Pro requires %s to be active to work', 'kadence-woocommerce-elementor-pro' ).'</p>', '<a target="_blank" href="https://wordpress.org/plugins/woocommerce/">WooCommerce</a>');
		echo '</div>';
	}
	// Add a notice about elementor being needed.
	public function admin_notice_need_elementor() {
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p>'.sprintf( __( 'Kadence Woocommerce Elementor Pro requires %s to be active to work', 'kadence-woocommerce-elementor-pro' ).'</p>', '<a target="_blank" href="https://wordpress.org/plugins/elementor/">Elementor</a>');
		echo '</div>';
	}
	// Add a notice about Kadence Woocommerce Elementor being needed.
	public function admin_notice_need_kt_woo_ele() {
		echo '<div class="notice notice-error is-dismissible">';
		echo '<p>'.sprintf( __( 'Kadence Woocommerce Elementor Pro requires %s to be active to work', 'kadence-woocommerce-elementor-pro' ).'</p>', '<a target="_blank" href="https://wordpress.org/plugins/kadence-woocommerce-elementor/">Kadence Woocommerce Elementor</a>');
		echo '</div>';
	}
	public static function get_default_loop_setting() {
		$value = null;
		// Get all stored values
		$stored = get_option( 'kt_woo_ele_loop_template_default', null );
		// Check if value exists in stored values array
		if ( ! empty( $stored ) ) {
			$value = $stored;
		}
		// Stored value not found, use default value
		return apply_filters( 'kadence_woo_ele_default_loop_setting', $value );
	}
	public static function get_default_category_setting() {
		$value = null;
		// Get all stored values
		$stored = get_option( 'kt_woo_ele_category_template_default', null );
		// Check if value exists in stored values array
		if ( ! empty( $stored ) ) {
			$value = $stored;
		}
		// Stored value not found, use default value
		return apply_filters( 'kadence_woo_ele_default_category_setting', $value );
	}
	public static function get_default_tag_setting() {
		$value = null;
		// Get all stored values
		$stored = get_option( 'kt_woo_ele_tag_template_default', null );
		// Check if value exists in stored values array
		if ( ! empty( $stored ) ) {
			$value = $stored;
		}
		// Stored value not found, use default value
		return apply_filters( 'kadence_woo_ele_default_tag_setting', $value );
	}
	public static function get_default_shop_setting() {
		$value = null;
		// Get all stored values
		$stored = get_option( 'kt_woo_ele_shop_template_default', null );
		// Check if value exists in stored values array
		if ( ! empty( $stored ) ) {
			$value = $stored;
		}
		// Stored value not found, use default value
		return apply_filters( 'kadence_woo_ele_default_shop_setting', $value );
	}
	public static function get_default_checkout_setting() {
		$value = null;
		// Get all stored values
		$stored = get_option( 'kt_woo_ele_checkout_template_default', null );
		// Check if value exists in stored values array
		if ( ! empty( $stored ) ) {
			$value = $stored;
		}
		// Stored value not found, use default value
		return apply_filters( 'kadence_woo_ele_default_checkout_setting', $value );
	}
}

Kadence_Woocommerce_Elementor_Pro::get_instance();

/** 
 * Checks if WooCommerce is enabled
 */
class Kadence_Woocommerce_Elementor_Pro_Plugin_Check {

	private static $active_plugins;

	public static function init() {

	self::$active_plugins = (array) get_option( 'active_plugins', array() );

	if ( is_multisite() )
		self::$active_plugins = array_merge( self::$active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
	}

	public static function active_check_woo() {

		if ( ! self::$active_plugins ) {
			self::init();
		}
		return in_array( 'woocommerce/woocommerce.php', self::$active_plugins ) || array_key_exists( 'woocommerce/woocommerce.php', self::$active_plugins );
	}
	public static function active_check_ele() {

		if ( ! self::$active_plugins ) {
			self::init();
		}
		return in_array( 'elementor/elementor.php', self::$active_plugins ) || array_key_exists( 'elementor/elementor.php', self::$active_plugins );
	}
	public static function active_check_kt_woo_ele() {

		if ( ! self::$active_plugins ) {
			self::init();
		}
		return in_array( 'kadence-woocommerce-elementor/kadence-woocommerce-elementor.php', self::$active_plugins ) || array_key_exists( 'kadence-woocommerce-elementor/kadence-woocommerce-elementor.php', self::$active_plugins );
	}

}

function kadence_wooele_pro_is_woo_active() {
	return Kadence_Woocommerce_Elementor_Pro_Plugin_Check::active_check_woo();
}
function kadence_wooele_pro_is_ele_active() {
	return Kadence_Woocommerce_Elementor_Pro_Plugin_Check::active_check_ele();
}
function kadence_wooele_pro_is_kt_woo_ele_active() {
	return Kadence_Woocommerce_Elementor_Pro_Plugin_Check::active_check_kt_woo_ele();
}

function kwep_theme_is_kadence() {
	if ( class_exists( 'kt_api_manager' ) ) {
		return true;
	}
	return false;
}

// Plugin Updates
add_action( 'after_setup_theme', 'kwep_updating', 1 );
function kwep_updating() {
	require_once 'wp-updates-plugin.php';
	require_once KT_WOOELE_PRO_PATH . 'admin/kadence_activation/kadence-plugin-api-manager.php';
	if ( get_option( 'kadence_woocommerce_elementor_pro_activation' ) == 'Activated' ) {
		$kadence_woo_ele_pro_updater = new PluginUpdateChecker_2_0 ( 'https://kernl.us/api/v1/updates/5b2d74824e6302592f3f9814/', __FILE__ , 'kadence-woocommerce-elementor-pro', 1 );
	}
}
