<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

\Elementor\Plugin::$instance->frontend->add_body_class( 'elementor-template-canvas' );

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php if ( ! current_theme_supports( 'title-tag' ) ) : ?>
		<title><?php echo wp_get_document_title(); ?></title>
	<?php endif; ?>
	<?php wp_head(); ?>
	<?php
	// Keep the following line after `wp_head()` call, to ensure it's not overridden by another templates.
	echo '<style>.kadence-product-loop-preview {
    max-width: 324px;
    margin: 100px auto 0;
    border: 2px dashed #eee;
}
.kadence-product-loop-columns-4 {
	max-width:240px;
}
.kadence-product-loop-columns-5, .kadence-product-loop-columns-6 {
	max-width:200px;
}
.kadence-product-loop-columns-2 {
	max-width:480px;
}
.kadence-product-loop-columns-1 {
	max-width:970px;
}
.elementor-widget-wrap ul.products {
    margin-left: 0;
    margin-bottom: 0;
    clear: both;
    padding: 0;
    list-style:none;
}
.elementor-widget-wrap ul.products li.product {
    width: 100%;
    float: none;
    margin:0;
    padding:0;
    text-align:inherit;
    list-style:none;
}
body.single-ele-p-loop-template {
background:white;
}</style>'
	?>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover" />
</head>
<body <?php body_class(); ?>>
	<?php
	$columns = wc_get_default_products_per_row();
	?>
	<div class="woocommerce kadence-product-loop-preview kadence-product-loop-columns-<?php echo esc_attr( $columns ); ?>">
	<?php
	/**
	 * Before canvas page template content.
	 *
	 * Fires before the content of Elementor canvas page template.
	 *
	 * @since 1.0.0
	 */
	do_action( 'elementor/page_templates/canvas/before_content' );

	\Elementor\Plugin::$instance->modules_manager->get_modules( 'page-templates' )->print_content();

	/**
	 * After canvas page template content.
	 *
	 * Fires after the content of Elementor canvas page template.
	 *
	 * @since 1.0.0
	 */
	do_action( 'elementor/page_templates/canvas/after_content' );

	wp_footer();
	?>
	</div>
	</body>
</html>
