<?php
/**
 * Plugin Name: Analytify UTM Campaigns Tracking
 * Plugin URI: https://analytify.io/
 * Description: Our Campaign Tracking addon will help you track your marketing efforts. This addon will provide UTM tracking data in a beautiful dashboard which can help in better decision making.
 * Version: 5.0.0
 * Author: WPBrigade
 * Author URI: https://wpbrigade.com/
 * License: GPLv2+
 * Min WP Version: 3.0
 * Text Domain: wp-analytify-campaings
 * Domain Path: /languages
 *
 * @package  WP Analytify Campaings Addons
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

update_option( 'analytify_campaigns_license_status', 'valid' );
update_option( 'analytify_campaigns_license_key' , 'B5E0B5F8DD8689E6ACA49DD6E6E1A930' );

define( 'ANALTYIFY_CAMPAIGNS_VERSION', '5.0.0' );
define( 'ANALYTIFY_PRO_CAMPAINGS_ROOT_PATH', dirname( __FILE__ ) );
define( 'ANALYTIFY_CAMPAIGNS_UPGRADE_PATH', __FILE__ );

add_action( 'plugins_loaded', 'load_analytify_campaigns', 20 );

/**
 * Loads the plugin files.
 *
 * @return void
 */
function load_analytify_campaigns() {
	$prevent = false;

	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
		add_action( 'admin_notices', 'install_analytify_pro_campaigns' );
		$prevent = true;
	} elseif ( ! class_exists( 'WP_Analytify_Pro_Base' ) ) {
		add_action( 'admin_notices', 'active_analytify_pro_campaigns' );
		$prevent = true;
	}

	if ( $prevent ) {
		add_action( 'admin_enqueue_scripts', 'wp_analytify_campaigns_notices_scripts' );
		return;
	}

	include_once ANALYTIFY_PRO_CAMPAINGS_ROOT_PATH . '/classes/class-campaigns.php';
	include_once ANALYTIFY_PRO_CAMPAINGS_ROOT_PATH . '/classes/class-campaign-rest-api.php';
}

/**
 * Generates ad admin message if Pro version is not installed.
 *
 * @return void
 */
function install_analytify_pro_campaigns() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-campaings' ) . ' </strong>' . esc_html__( 'Please install Analytify Pro to use Analytify for Campaigns addon.', 'wp-analytify-campaings' );

	wp_analytify_campaigns_notice( $message, 'wp-analytify-danger' );
}

/**
 * Generates ad admin message if Pro version is installed, but not active.
 *
 * @return void
 */
function active_analytify_pro_campaigns() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-campaings' ) . ' </strong>' . esc_html__( 'Please active Analytify Pro to use Analytify for Campaigns addon.', 'wp-analytify-campaings' );

	wp_analytify_campaigns_notice( $message, 'wp-analytify-danger' );
}

/**
 * Load TextDoamin
 *
 * @since 1.0.2
 */
function wp_analytify_campaings_load_text_domain() {
	$plugin_dir = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( 'wp-analytify-campaings', false, $plugin_dir . '/languages/' );
}
add_action( 'init', 'wp_analytify_campaings_load_text_domain' );


/**
 * Helper function for translation.
 */
if ( ! function_exists( 'analytify__' ) ) {
	/**
	 * Wrapper for __() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify__( $string, $textdomain = 'wp-analytify' ) {
		return __( $string, $textdomain );
	}
}

if ( ! function_exists( 'analytify_e' ) ) {
	/**
	 * Wrapper for _e() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify_e( $string, $textdomain = 'wp-analytify' ) {
		echo __( $string, $textdomain );
	}
}

/**
 * Add custom admin notice
 *
 * @param  string $message Custom Message
 * @param  string $class wp-analytify-success,wp-analytify-danger
 */
function wp_analytify_campaigns_notice( $message, $class ) {
	echo '<div class="wp-analytify-notification ' . $class . '">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message . '</p>
	</div>
	</div>';
}

/**
 * Admin notices scripts.
 */
function wp_analytify_campaigns_notices_scripts() {
	wp_enqueue_style( 'wp-analytify-campaings-notices-css', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALTYIFY_CAMPAIGNS_VERSION );
}
