<?php
/**
 * Output EDD Report section in email.
 *
 * @since 1.2.6
 */
function pa_email_include_edd_general( $current, $stats ) {

	ob_start();
	?>
	<tr>
		<td valign="top" style="border: 1px solid #e2e5e8;">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" bgcolor="#f9fafa">
				<tr>
					<td style="font: normal 16px 'Roboto slab', Arial, Helvetica, sans-serif; padding: 11px 20px;"><font color="#444444"><?php analytify_e( 'E-Commerce Statistics', 'wp-analytify' ); ?></font></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td style="border:1px solid #e2e5e8; border-top: 0;" bgcolor="#ffffff"  class="session-table">
			<table cellspacing="20" cellpadding="0" border="0" align="center" bgcolor="#f9fafa" width="100%" class="box-table">
				<tr>
					<td style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Transactions', 'wp-analytify-email' ); ?></font></td>
							</tr>
							<tr>
								<td width="45" ></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo number_format( $stats->totalsForAllResults['ga:transactions'] ); ?></font></td>
							</tr>
						</table>
					</td>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Transaction Revenues', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo edd_currency_symbol() . number_format( $stats->totalsForAllResults['ga:transactionRevenue'], 2 ); ?></font></td>
							</tr>
						</table>
					</td>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Average Order Value', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo edd_currency_symbol() . number_format( $stats->totalsForAllResults['ga:revenuePerTransaction'], 2 ); ?></font></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Product Adds To Cart', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo $stats->totalsForAllResults['ga:productAddsToCart'] ?></font></td>
							</tr>
						</table>
					</td>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Product Removes From Cart', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo $stats->totalsForAllResults['ga:productRemovesFromCart']; ?></font></td>
							</tr>
						</table>
					</td>
					<td style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Product Checkouts', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45" ></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo WPANALYTIFY_Utils::pretty_numbers( $stats->totalsForAllResults['ga:productCheckouts'] ) ?></font></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Refund Amount', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45" ></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color=""><?php echo edd_currency_symbol() . number_format( $stats->totalsForAllResults['ga:refundAmount'], 2 ); ?></font></td>
							</tr>
						</table>
					</td>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Total Refunds', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo $stats->totalsForAllResults['ga:totalRefunds']; ?></font></td>
							</tr>
						</table>
					</td>
					<td  style="border: 1px solid #e2e5e8;" width="33.333%">
						<table width="100%" cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff">
							<tr>
								<td align="center" colspan="3" style="font: 500 14px 'Roboto', Arial, Helvetica, sans-serif;padding: 16px 5px 5px; text-transform: uppercase; letter-spacing: 0.01em;"><font color="#848484"><?php esc_html_e( 'Product Detail Views', 'wp-analytify-woocommerce' ); ?></font></td>
							</tr>
							<tr>
								<td width="45"></td><td align="center"><hr style="margin:0;border:0;border-top: 1px solid #e5e5e5;"/></td><td width="45"></td>
							</tr>
							<tr>
								<td align="center" colspan="3" style="padding: 13px 5px 10px; font: 400 24px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php echo WPANALYTIFY_Utils::pretty_numbers( $stats->totalsForAllResults['ga:productDetailViews'] ) ?></font></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td style="border:1px solid #e2e5e8; border-top: 0;">
			<table cellpadding="0" cellspacing="16px" border="0" width="100%" bgcolor="#f9fafa">
				<tr>
					<td width="32" style="text-align: right;"><img src="<?php echo ANALYTIFY_IMAGES_PATH . 'anlytify_about_icon.png'; ?>" alt=""></td>
					<td style="font: normal 13px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444">
					<?php
					echo sprintf( esc_html__( 'Did you know that Ecommerce Conversion Rate on your site is %1$s', 'wp-analytify-woocommerce' ), number_format( $stats->totalsForAllResults['ga:transactionsPerSession'], 2 ) ) . '%?';
					?>
					</font></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td style="padding:15px;"></td>
	</tr>
	<?php
	$message = ob_get_clean();
	return $message;
}
?>
