<?php

/**
 * Generates the main view for the dashboard.
 * 
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wpanalytify analytify-dashboard-nav">
	<div class="wpb_plugin_wraper">
		<div class="wpb_plugin_header_wraper">
			<div class="graph"></div>
			<div class="wpb_plugin_header">
				<div class="wpb_plugin_header_title"></div>
				<div class="wpb_plugin_header_info">
					<a href="https://analytify.io/changelog/" target="_blank" class="btn"><?php
						// Translators: %s: Analytify core version
						echo sprintf( esc_html__( 'Changelog - v%s', 'wp-analytify-authors' ), $version );
					?></a>
				</div>
				<div class="wpb_plugin_header_logo">
					<img src="<?php echo ANALYTIFY_PLUGIN_URL . 'assets/img/logo.svg'?>" alt="Analytify">
				</div>
			</div>
		</div>

		<div class="analytify-dashboard-body-container">
			<div class="wpb_plugin_body_wraper">
				<div class="wpb_plugin_body">
					<div class="wpa-tab-wrapper">

						<?php if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) { echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation(); } ?>
					</div>
					<div class="wpb_plugin_tabs_content analytify-dashboard-content">
						<div class="analytify_wraper">
							<div class="analytify_main_title_section">
								<div class="analytify_dashboard_title">

									<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Forms Tracking Dashboard', 'wp-analytify-forms' ); ?></h1>

									<?php
									if ( $dashboard_profile_id ) {
										if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
											if ( $access_token ) {
												if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
													if ( $access_token && method_exists( 'WPANALYTIFY_Utils', 'dashboard_subtitle_section' ) ) {
														WPANALYTIFY_Utils::dashboard_subtitle_section();
													}
												}
											}
										}
									}
									?>

								</div>

								<div class="analytify_main_setting_bar">
									<div class="analytify_pull_right analytify_setting">
										<div class="analytify_select_date">

											<?php
											if ( $dashboard_profile_id ) {
												if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
													if ( $access_token ) {
														if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' )  ) {
															WPANALYTIFY_Utils::date_form( $start_date, $end_date );
														}
													}
												}
											}
											?>

										</div>
									</div>
								</div>
							</div>

							<?php
							if ( ! WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Forms Tracking' ) ) {
								if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
									if ( $access_token ) {

										$forms_for_dashboard = AnalytifyFormHelper::get_forms_for_dashboard();

										if ( ! empty( $forms_for_dashboard ) ) {

											$first = false;
											foreach ( $forms_for_dashboard as $form ) {
												?>
												<div id="section-<?php echo esc_html( $form['category'] ); ?>" class="analytify_author_dashboard analytify_status_box_wraper form-section"<?php if ( ! $first ) { ?> data-endpoint-forms="main-dashboard"<?php } ?>>
													<div class="analytify_status_header analytify_header_adj">
														<h3>
															<?php
															// Translators: %s is the form name.
															echo sprintf( esc_html__( '\'%s\' Stats', 'wp-analytify-forms' ), $form['title'] );
															if ( defined( 'ANALYTIFY_PRO_VERSION' ) && 0 <= version_compare( ANALYTIFY_PRO_VERSION, '5.0.0' ) ) {
															?>
															<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="forms-dashboard" data-args="<?php echo $form['category']; ?>">
																<span class="analytify_tooltiptext"><?php esc_html_e( 'Export Stats', 'wp-analytify-pro' ); ?></span>
															</a>
															<?php } ?>
														</h3>
													</div>
													<div class="analytify_status_body">
														<div class="stats-wrapper"></div>
													</div>
													<div class="analytify_stats_loading">
														<table class="analytify_data_tables">
															<thead>
																<tr>
																	<th class="analytify_num_row"><p class="skt-loading light-gray"></p></th>
																	<th class="analytify_txt_left"><p class="skt-loading light-gray"></p></th>
																	<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																	<th class="analytify_value_row"><p class="skt-loading light-gray"></p></th>
																</tr>
															</thead>
															<tbody>
																<?php for ( $i = 0; $i < 5; $i++ ) { ?>
																<tr>
																	<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																	<td><p class="skt-loading"></p></td>
																	<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																	<td class="analytify_txt_center"><p class="skt-loading"></p></td>
																</tr>
																<?php } ?>
															</tbody>
														</table>
													</div>
												</div>
												<?php
												$first = true;
											}
										} else {
											?>
											<div class="analytify-email-promo-contianer">
												<div class="analytify-email-premium-overlay">
													<div class="analytify-email-premium-popup">
														<h3 class="analytify-promo-popup-heading" style="text-align:left;"><?php esc_html_e( 'Form Tracking is not enabled!', 'wp-analytify-forms' ); ?></h3>
														<p class="analytify-promo-popup-paragraph analytify-error-popup-paragraph">
															<?php esc_html_e( 'Form Tracking is not enabled for any forms. Please go to Analytify Settings > Tracking > Forms Tracking and enable tracking for forms.', 'wp-analytify-forms' ); ?>
														</p>
													</div>
												</div>
											</div>
											<?php
										}
									} else {
										esc_html_e( 'You must be logged in to see the Analytics Dashboard.', 'wp-analytify-forms' );
									}
								} else {
									esc_html_e( 'You don\'t have access to Forms Dashboard.', 'wp-analytify-forms' );
								}
							}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
