<?php
/**
 * Plugin Name: Analytify Forms
 * Plugin URI: https://analytify.io/add-ons/forms-tracking/?utm_source=analytify-forms&utm_medium=plugin-uri
 * Description: This is a premium add-on to show you All forms tracking results from Google Analytics in a Dashboard.
 * Version: 5.0.0
 * Author: WPBrigade
 * Author URI: https://wpbrigade.com/?utm_source=analytify-forms&utm_medium=authors-uri
 * Text Domain: wp-analytify-forms
 * Domain Path: /languages
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
 	exit; // Exit if accessed directly
}

update_option( 'analytify_forms_license_status', 'valid' );
      update_option( 'analytify_forms_license_key' , 'B5E0B5F8DD8689E6ACA49DD6E6E1A930' );

define( 'ANALYTIFY_FORMS_VERSION', '5.0.0' );
define( 'ANALYTIFY_FORMS_ROOT_PATH', dirname( __FILE__ ) );

// The minimum version of Analytify
define( 'ANALYTIFY_FORM_MIN_V_ANALYTIFY', '4.0.0' );

// The minimum version of Analytify Pro
define( 'ANALYTIFY_FORM_MIN_V_ANALYTIFY_PRO', '4.0.0' );

// custom forms tracking class name
define( 'ANALYTIFY_FORMS_CUSTOM_FORM_CLASS', 'analytify_form_custom' );


add_action( 'plugins_loaded' , 'analytify_forms_instance' , 20 );

function analytify_forms_instance(){
	$prevent = false;

 	// check for analytify
 	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
 		add_action( 'admin_notices' , 'wpa_forms_install_analytify_pro' );
 		$prevent = true;
 	} else if ( ! class_exists( 'WP_Analytify_Pro_Base' ) ) {
 		add_action( 'admin_notices' ,  'wpa_forms_active_analytify_pro' );
 		$prevent = true;
 	}

	if ( $prevent ) {
		add_action( 'admin_enqueue_scripts', 'wpa_forms_notices_scripts' );
		return;
	}

	// load the main plugin file
	if ( ! function_exists( 'get_plugins' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
	}

	// get all plguins
	$plugins = get_plugins();

	// check for the main plugin version
	if ( !isset($plugins['wp-analytify/wp-analytify.php']) || version_compare($plugins['wp-analytify/wp-analytify.php']['Version'], ANALYTIFY_FORM_MIN_V_ANALYTIFY, '<') ) {
		add_action( 'admin_notices', 'wpa_forms_notice_version_analytify' );
	}
	
	// check for the pro version
	if ( !isset($plugins['wp-analytify-pro/wp-analytify-pro.php']) || version_compare($plugins['wp-analytify-pro/wp-analytify-pro.php']['Version'], ANALYTIFY_FORM_MIN_V_ANALYTIFY_PRO, '<') ) {
		add_action( 'admin_notices', 'wpa_forms_notice_version_analytify_pro' );
	}
	
	// Set to default if tracking mode not set.
	if ( ! defined( 'ANALYTIFY_TRACKING_MODE' ) ) {
		define( 'ANALYTIFY_TRACKING_MODE', 'ga' );
	}

 	include_once ANALYTIFY_FORMS_ROOT_PATH . '/classes/analytify-forms-dashboard.php';
}


/**
 * Admin notice if Analytify Pro not installed.
 *
 * @since 1.0
 */
function wpa_forms_install_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . esc_html__( 'Please install Analytify Pro to use Analytify - Forms addon.', 'wp-analytify-forms' );
	wpa_forms_notice( $message, 'wp-analytify-danger' );
}

/**
 * Admin notice if Analytify Pro not activated.
 *
 * @since 1.0
 */
function wpa_forms_active_analytify_pro() {
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . esc_html__( 'Please activate Analytify Pro to use Analytify - Forms addon.', 'wp-analytify-forms' );
	wpa_forms_notice( $message, 'wp-analytify-danger' );
}

/**
 * Admin notice for the Analytify version.
 * 
 */
function wpa_forms_notice_version_analytify() {
	// Translators: %s is the version of the core plugin.
	$text    = sprintf( esc_html__( 'The minimum version of Analytify required for Analytify Forms addon is %s. You need to update Analytify Core (Free)', 'wp-analytify-forms' ), ANALYTIFY_FORM_MIN_V_ANALYTIFY );
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . $text;
	wpa_forms_notice( $message, 'wp-analytify-danger' );
}


/**
 * Admin notice for the Analytify Pro version.
 * 
 */
function wpa_forms_notice_version_analytify_pro() {
	// Translators: %s is the version of the pro plugin.
	$text    = sprintf( esc_html__( 'The minimum version of Analytify Pro required for Analytify Forms addon is %s. You need to update Analytify Pro.', 'wp-analytify-forms' ), ANALYTIFY_FORM_MIN_V_ANALYTIFY_PRO );
	$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . $text;
	wpa_forms_notice( $message, 'wp-analytify-danger' );
}

/**
 * Load TextDoamin
 *
 * @since 1.0
 */
function wpa_forms_load_textdomain() {
	$plugin_dir = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( 'wp-analytify-forms', false, $plugin_dir . '/languages/' );
}
add_action( 'init', 'wpa_forms_load_textdomain' );

/**
 * Add custom admin notice
 * 
 * @param string $message Custom message
 * @param string $class wp-analytify-success,wp-analytify-danger
 */
function wpa_forms_notice( $message, $class ) {
	echo '<div class="wp-analytify-notification ' . $class . '">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message .'</p>
	</div>
	</div>';
}

/**
 * Admin notices scripts.
 */
function wpa_forms_notices_scripts() {
	wp_enqueue_style( 'wpa-forms-notices-css', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALYTIFY_FORMS_VERSION );
}

