<?php
// Retrieve the `wp_analytify_modules` option.
$analytify_modules = get_option('wp_analytify_modules');

// Ensure it's an array before processing.
if (is_array($analytify_modules)) {
    // Filter out the 'google-optimize' module.
    $analytify_modules = array_filter($analytify_modules, function($module) {
        return $module['slug'] !== 'google-optimize';
    });

    // Save the updated option back to the database.
    update_option('wp_analytify_modules', $analytify_modules);

    // Loop through active modules except 'google-ads-tracking'
    foreach ($analytify_modules as $module) {
        if ('active' === $module['status'] && $module['slug'] != 'google-ads-tracking') {
            $module_file = ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/' . $module['slug'] . '/classes/' . $module['slug'] . '.php';
            if (file_exists($module_file)) {
                include_once $module_file;
            }
        }
    }
}

// Including google ads file.
$google_ads_file = ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/google-ads.php';
if (file_exists($google_ads_file)) {
    include_once $google_ads_file;
}
