jQuery(document).ready(function($) {

    var doing_license_registration_ajax = false;
    var admin_url = ajaxurl.replace( '/admin-ajax.php', '' ), spinner_url = admin_url + '/images/spinner';
  
    if ( 2 < window.devicePixelRatio ) {
      spinner_url += '-2x';
    }
    spinner_url += '.gif';
  
    var ajax_spinner = '<img src="' + spinner_url + '" alt="" class="ajax-spinner general-spinner" />';
  
    $( document ).on( 'click', "#analytify_authors_license_activate", function(e) {
  
      e.preventDefault();
  
      if ( doing_license_registration_ajax ) {
        return;
      }
  
      $( '#authors-license-status' ).removeClass( 'notification-message error-notice' );
  
      var license_key = $.trim( $( "#analytify_authors_license_key" ).val() );
  
      if ( '' === license_key ) {
        $( '#authors-license-status' ).addClass( 'notification-message error-notice' );
        $( '#authors-license-status' ).html( wpanalytify_strings.enter_license_key );
        return;
      }
  
      $( '#authors-license-status' ).empty().removeClass( 'success-notice' );

      doing_license_registration_ajax = true;

      $( '#analytify_authors_license_activate' ).after( '<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />' );
  
      $.ajax( {
        url: ajaxurl,
        type: 'POST',
        dataType: 'JSON',
        cache: false,
        data: {
          action: 'wpanalytify_authors_activate_license',
          authors_license_key: license_key,
          nonce: wpanalytify_data.nonces.activate_license,
          context: 'license'
        },
        error: function( jqXHR, textStatus, errorThrown ) {
          doing_license_registration_ajax = false;
          $( '.register-license-ajax-spinner' ).remove();
          $( '#authors-license-status' ).html( wpanalytify_strings.register_license_problem );
        },
        success: function( data ) {
          doing_license_registration_ajax = false;
          $( '.register-license-ajax-spinner' ).remove();
  
  
          if ( 'undefined' !== typeof data.error ) {
  
            $( '#authors-license-status' ).addClass( 'notification-message error-notice' );
            $( '#authors-license-status' ).html( data.error );
  
          } else if ( data == '0' ){
  
            $( '#authors-license-status' ).addClass( 'notification-message error-notice' );
            $( '#authors-license-status' ).html( wpanalytify_strings.register_license_problem );
          }else {
            $( '#authors-license-status' ).html( wpanalytify_strings.license_registered ).delay( 5000 ).fadeOut( 1000 );
            $( '#authors-license-status' ).addClass( 'notification-message success-notice' );
            $( '#analytify_authors_license_key, #analytify_authors_license_activate' ).remove();
            $( '.authors-license-row' ).prepend( data.masked_license );
  
          }
        }
      } );
    });
  });
  