<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Analytify_Form_Loader {

	public static $instance;

	public $version;

	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {
		$this->version = '6.1.0';
		$this->define_constants();
		$this->hooks();
		$this->may_be_load_addon();
	}

	public function may_be_load_addon() {
		if (
			file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' )
			&& function_exists( 'wp_analytify_pro_load' )
			&& class_exists( 'WP_Analytify_Pro_Base' )
		) {
			include_once ANALYTIFY_FORMS_ADDON_ROOT_PATH . '/classes/analytify-forms-dashboard.php';
		} else {
			add_action( 'admin_enqueue_scripts', array( $this, 'wpa_forms_notices_scripts' ) );
		}
	}

	public function define_constants() {
		$this->define( 'ANALYTIFY_FORMS_ADDON_VERSION', $this->version );
		$this->define( 'ANALYTIFY_FORMS_ADDON_ROOT_PATH', dirname( __FILE__ ) . '/' );
		$this->define( 'ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY', '4.0.0' );
		$this->define( 'ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY_PRO', '4.0.0' );
		$this->define( 'ANALYTIFY_FORMS_ADDON_CUSTOM_FORM_CLASS', 'analytify_form_custom' );
	}

	public function hooks() {
		add_action( 'admin_notices', array( $this, 'wpa_forms_notice_version_analytify' ) );
		add_action( 'admin_notices', array( $this, 'wpa_forms_notice_version_analytify_pro' ) );
		add_action( 'init', array( $this, 'wpa_forms_load_textdomain' ) );
	}

	public function wpa_forms_notices_scripts() {
		wp_enqueue_style( 'wpa-forms-notices-css', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALYTIFY_FORMS_ADDON_VERSION );
	}

	public function wpa_forms_notice_version_analytify() {
		// get all plguins
		$plugins = get_plugins();

		// check for the main plugin version
		if ( ! isset( $plugins['wp-analytify/wp-analytify.php'] ) || version_compare( $plugins['wp-analytify/wp-analytify.php']['Version'], ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY, '<' ) ) {
			$text    = sprintf( esc_html__( 'The minimum version of Analytify required for Analytify Forms addon is %s. You need to update Analytify Core (Free)', 'wp-analytify-forms' ), ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY );
			$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . $text;
			$this->wpa_forms_notice( $message, 'wp-analytify-danger' );
		}
	}

	public function wpa_forms_notice_version_analytify_pro() {

		$plugins = get_plugins();

		if ( !isset($plugins['wp-analytify-pro/wp-analytify-pro.php']) || version_compare($plugins['wp-analytify-pro/wp-analytify-pro.php']['Version'], ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY_PRO, '<') ) {
			$text    = sprintf( esc_html__( 'The minimum version of Analytify Pro required for Analytify Forms addon is %s. You need to update Analytify Pro.', 'wp-analytify-forms' ), ANALYTIFY_FORM_ADDON_MIN_V_ANALYTIFY_PRO );
			$message = '<strong>' . esc_html__( 'Attention:', 'wp-analytify-forms' ) . '</strong>' . $text;
			$this->wpa_forms_notice( $message, 'wp-analytify-danger' );
		}
	}


	/**
	 * Add custom admin notice
	 *
	 * @param  string $message Custom Message
	 * @param  string $class wp-analytify-success,wp-analytify-danger
	 */
	public function wpa_forms_notice( $message, $class ) {
		echo '<div class="wp-analytify-notification ' . $class . '">
		<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
		<div class="wp-analytify-notice-logo">
		<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
		</div>
		<div class="wp-analytify-notice-discription">
		<p>' . $message . '</p>
		</div>
		</div>';
	}

	public function wpa_forms_load_textdomain() {
		$plugin_dir = basename( dirname( __FILE__ ) );
		load_plugin_textdomain( 'wp-analytify-forms', false, $plugin_dir . '/languages/' );
	}

	public function define( $constant, $value ) {
		if ( ! defined( $constant ) ) {
			define( $constant, $value );
		}
	}

}

Analytify_Form_Loader::get_instance();
