<?php
if (!class_exists('WP_Analytify_Goals')) {
class WP_Analytify_Goals extends WP_Analytify_Pro_Base {

	function __construct() {
		parent::__construct();
		$this->hooks();
		$this->setup_constants();
	}

	/**
	 * hooks used to run the plugin
	 *
	 * @since 1.0.0
	 */
	function hooks() {

		add_action( 'analytify_add_submenu', array( $this, 'add_submenu' ), 40 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_action( 'analytify_dashboad_dropdown_option' , array( $this, 'dashboad_dropdown_option' ), 8 );
		// for modifing the meta links
		add_action( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );

	}

	/**
	 * Plugin row meta links
	 * 
	 * @param array  $input already defined meta links
	 * @param string $file plugin file path and name being processed
	 * @return array $input
	 */
	function plugin_row_meta( $input, $file ) {

		// exit if its other plugins
		if ( 'wp-analytify-goals/wp-analytify-goals.php' !== $file ) { return $input; }

		// remove the 'view details' org link
		unset( $input[2] );

		// add the plugin site link
		$input[] = '<a target="_blank" href="https://analytify.io/add-ons/google-analytics-goals-wordpress/">Visit plugin site</a>';

		return $input;

	}

	/**
	 * Define constant if not already set
	 *
	 * @param  string      $name
	 * @param  string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Setup plugin constants
	 *
	 * @access      private
	 * @since       1.0.0
	 * @return      void
	 */
	private function setup_constants() {

		// Setting Global Values
		$this->define( 'GOALS_ANALYTIFY_ADDON_PLUGIN_FILE', __FILE__ );
		$this->define( 'GOALS_ANALYTIFY_ADDON_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'GOALS_ANALYTIFY_ADDON_PLUGIN_DIR', dirname( __FILE__ ) );
		$this->define( 'GOALS_ANALYTIFY_ADDON_PRODUCT_NAME', 'Analytify - Goals Addon' );
		$this->define( 'GOALS_ANALYTIFY_ADDON_PRODUCT_ID', 14243 );
		$this->define( 'GOALS_ANALYTIFY_ADDON_STORE_URL', 'https://analytify.io' );
	}

	/**
	 * Load Admin Scripts
	 *
	 * @since 1.0
	 */
	function admin_scripts( $page ) {
		if ( 'analytify_page_analytify-settings' == $page ) {
			// wp_enqueue_script( 'analytify_goals_main_js', plugins_url( 'assets/js/main.js', __FILE__ ), array( 'jquery' ), ANALYTIFY_GOALS_ADDON_VERSION );
		}
	}

	/**
	 * Create Submenu under Analytify
	 *
	 * @since 1.0
	 */
	function add_submenu() {
		add_submenu_page( 'analytify-dashboard', ANALYTIFY_NICK . esc_html__( 'Goals (Key Events)', 'wp-analytify-goals' ), esc_html__( 'Goals (Key Events)', 'wp-analytify-goals' ), 'manage_options', 'analytify-goals', array( $this, 'pa_page_file_path' ), 30 );
	}

	/**
	 * Analytify Goal Page callback.
	 *
	 * @since 1.0
	 */
	function pa_page_file_path() {

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
			if ( isset( $_GET['goal_id'] ) && ! empty( $_GET['goal_id'] ) ) {
				include_once ANALYTIFY_GOALS_ADDON_ROOT_PATH . 'includes/analytify-goals-detail-view.php';
			} else {
				include_once ANALYTIFY_GOALS_ADDON_ROOT_PATH . '/includes/analytify-goals-view.php';
			}
		} else {
			if ( isset( $_GET['goal_id'] ) && ! empty( $_GET['goal_id'] ) ) {
				include_once ANALYTIFY_GOALS_ADDON_ROOT_PATH . 'includes/analytify-goals-detail-view-deprecated.php';
			} else {
				include_once ANALYTIFY_GOALS_ADDON_ROOT_PATH . 'includes/analytify-goals-view-deprecated.php';
			}
		}
	}

	/**
	* Add dropdown option for goals dashboard.
	*
	*/
	function dashboad_dropdown_option() {
		echo  '<li><a href="'. admin_url( 'admin.php?page=analytify-goals' ) .'">' . __( 'Goals', 'wp-analytify-goals') . '</a></li>';
	}
}


new WP_Analytify_Goals();
}