<?php
/**
 * Product categories performance view.
 *
 * @param object $current
 * @param object $stats
 * @return void
 */
function wpa_woocommerce_categories_performance( $current, $stats ) {

	ob_start();
	?>

    <div class="analytify_general_status analytify_status_box_wraper">
      <div class="analytify_status_header">
		<h3>
			<?php esc_html_e( 'Product Categories Analysis', 'wp-analytify-woocommerce' ); ?>
			<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="product-categories">
				<span class="analytify_tooltiptext"><?php _e( 'Export Product Categories Analysis', 'wp-analytify-pro' ) ?></span>
			</a>
			<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
		</h3>
      </div>
      <div class="analytify_status_body">

        <table class="analytify_data_tables">
          <thead>
            <tr>
              <th class="analytify_table_header_no_events">
                #
              </th>
              <th>
                <?php esc_html_e( 'Name',  'wp-analytify-woocommerce' ); ?>
              </th>
              <th>
                <?php esc_html_e( 'Product Revenue', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Quantity', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-woocommerce' ); ?>
              </th>
            </tr>
          </thead>
          <tbody>
            <?php if ( ! empty( $stats['rows'] ) ) {
              $i = 0;
              foreach ( $stats['rows'] as $stat ) {
                $i++;
                ?>
                <tr>
                  <td data-heading="#">
                    <?php echo $i; ?>
                  </td>
                  <td data-heading="<?php esc_html_e( 'Name',  'wp-analytify-woocommerce' ); ?>">
                    <?php echo $stat['itemCategory']; ?>
                  </td>
                  <td data-heading="<?php esc_html_e( 'Product Revenue', 'wp-analytify-woocommerce' ); ?>" class="analytify_txt_center">
                  <?php
                  $currency_code = ( isset( $stat['currencyCode'] ) && $stat['currencyCode'] !== '(not set)' ) ? $stat['currencyCode'] : '';
                  echo WP_Analytify_WooCommerce_Addon::analytify_format_currency($stat['itemRevenue'], $currency_code);
                  ?>
                  </td>
                  <td data-heading="<?php esc_html_e( 'Quantity', 'wp-analytify-woocommerce' ); ?>" class="analytify_txt_center">
                    <?php echo $stat['itemPurchaseQuantity']; ?>
                  </td>
                  <td data-heading="<?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-woocommerce' ); ?>">
                    <?php $percent_quantity = WPANALYTIFY_Utils::fraction_to_percentage( $stat['cartToViewRate'] );?>
                    <?php echo $percent_quantity; ?> %
                    <span class="analytify_bar_graph">
                      <span style="width: <?php echo $percent_quantity ?>%;"></span>
                    </span>
                  </td>
                </tr>
                <?php
              }
            } else { ?>
              <tr>
                <td  class="analytify_td_error_msg" colspan="7">
                  <?php $current->no_records(); ?>
                </td>
              </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
        <div class="analytify_status_footer">

          <?php if ( isset( $stats['rows'][0]['itemCategory'] ) ) : ?>
            <span class="analytify_info_stats">
              <?php
              echo sprintf( esc_html__( 'Did you know the famous Product Category in your store is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>' , $stats['rows'][0]['itemCategory'], '</strong>' );
              ?>
            </span>
          <?php endif; ?>

        </div>
	</div>
<?php 

wp_send_json( array( 
	'body' => ob_get_clean()
) );
}
      