<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class Analytify_WooCommerce_Loader
{

    public static $instance;
    public $version;

    public static function get_instance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

	public function __construct()
	{
		$this->version = '6.1.0';
		$this->define_constants();
		$this->hooks();
		$this->may_be_load_addon();
	}
	public function may_be_load_addon()
	{	
		/**
		* Check for WooCommerce
		*/
	   if (!class_exists('WooCommerce')) {
		   add_action('admin_enqueue_scripts', array($this, 'wpa_woo_notices_scripts'));
		   add_action('admin_notices', array($this, 'wpa_check_woo_admin_notice'));
		   return;
	   }elseif (
			file_exists(WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php')
			&& function_exists('wp_analytify_pro_load')
			&& class_exists('WP_Analytify_Pro_Base')
		) {
			include_once ANALYTIFY_PRO_WOOCOMMERCE_ADDON_ROOT_PATH . '/class-wp-analytify-woo.php';
            // Global for backwards compatibility.
            $GLOBALS['WPAnalytifyProWooCommerce'] = WP_Analytify_WooCommerce_Addon::instance();
        }
    }

    public function define_constants()
    {
        define('ANALYTIFY_PRO_WOOCOMMERCE_VERSION', '6.1.0');
        define('ANALYTIFY_PRO_WOOCOMMERCE_ADDON_ROOT_PATH', dirname(__FILE__));
        define('ANALYTIFY_PRO_WOOCOMMERCE_UPGRADE_PATH', __FILE__);
        // Set to default if tracking mode not set.
        if (!defined('ANALYTIFY_PRO_TRACKING_MODE')) {
            define('ANALYTIFY_PRO_TRACKING_MODE', 'gtag');
        }
    }
    public function hooks()
    {

        add_action('admin_notices', array($this, 'wpa_check_analytify_admin_notice'));
        add_action('admin_notices', array($this, 'wpa_check_analytify_pro_admin_notice'));
        add_action('admin_notices', array($this, 'wpa_check_woo_admin_notice'));
        add_action('admin_notices', array($this, 'install_woo'));
        add_action('admin_enqueue_scripts', array($this, 'wpa_woo_notices_scripts'));

        /**
         * Action hook for declaring the WooCommerce HPOS compatibility with Analytify WooCommerce.
         */
        add_action('before_woocommerce_init', array($this, 'wpa_declare_hpos_compatability'));
        add_action('init', array($this, 'wp_analytify_woo_load_text_domain'));
        add_action('admin_footer', array($this, 'wp_analytify_woo_notice_script'));
        add_action('wp_ajax_dismiss_analytify_notice', array($this, 'dismiss_analytify_woo_notice'));
    }

    /**
     * Check Analytify free plugin installation.
     *
     * @return void
     */
    public function wpa_check_analytify_admin_notice()
    {
        if (!class_exists('WP_Analytify')) {
            $message = __('<strong>Attention:</strong> Analytify for WooCommerce works with the Analytify plugin. Please activate Analytify.', 'wp-analytify-woocommerce');
            $this->wp_analytify_woo_notice($message, 'wp-analytify-danger');
        }
    }
    /**
     * Check Analytify pro plugin installation.
     *
     * @return void
     */
    public function wpa_check_analytify_pro_admin_notice()
    {
        if (!class_exists('WP_Analytify_Pro')) {
            $message = __('<strong>Attention:</strong> Analytify for WooCommerce works with the Analytify PRO plugin. Please activate Analytify PRO.', 'wp-analytify-woocommerce');
            $this->wp_analytify_woo_notice($message, 'wp-analytify-danger');
        }
    }

    public function install_woo()
    {
        if (!file_exists(WP_PLUGIN_DIR . '/woocommerce/woocommerce.php')) {
            $message = __('<strong>Attention:</strong> Analytify for WooCommerce addon works with WooCommerce plugin, Please Install WooCommerce plugin.', 'wp-analytify-woocommerce');

            $this->wp_analytify_woo_notice($message, 'wp-analytify-danger');
        }
    }

    /**
     * Check WooCommerce plugin installation.
     *
     * @return void
     */
    public function wpa_check_woo_admin_notice()
    {
        if (file_exists(WP_PLUGIN_DIR . '/woocommerce/woocommerce.php') && !class_exists('WooCommerce')) {
            $message = __('<strong>Attention:</strong> Analytify for WooCommerce works with WooCommerce plugin, Please activate WooCommerce.', 'wp-analytify-woocommerce');
            $this->wp_analytify_woo_notice($message, 'wp-analytify-danger');
        }
    }
    
    /**
     * Provides the compatibility with WooCommerce HPOS
     *
     * Before HPOS WC relied on on the post and post-meta table structures to store order information.
     *
     * HPOS introduces dedicated tables for data which results in fewer read/write operations and fewer busy tables.
     *
     * HPOS enables e-commerce stores of all shapes and sizes to scale to their maximum potential.
     *
     * Analytify is Compatible
     */
    public function wpa_declare_hpos_compatability()
    {

        if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', ANALYTIFY_PRO_UPGRADE_PATH, true);
        }
    }
    /**
     * Admin notices scripts.
     */
    public function wpa_woo_notices_scripts()
    {
        wp_enqueue_style( 'wp-analytify-funnel-style', plugins_url( 'assets/css/funnel.css', __FILE__ ), false, ANALYTIFY_PRO_WOOCOMMERCE_VERSION );
        wp_enqueue_style('wpa-woo-notices-css', plugins_url('assets/css/notices.css', __FILE__), '', ANALYTIFY_PRO_WOOCOMMERCE_VERSION);
        wp_enqueue_script(
            'analytify-woocommerce-sort-tables',
            plugins_url('assets/js/sort-tables.js', __FILE__),
            array('jquery'),
            '1.0.0',
            true
        );
    }

    /**
     * Load TextDomain
     *
     * @since 1.0.2
     */
    public function wp_analytify_woo_load_text_domain()
    {

        $plugin_dir = basename(__DIR__);
        load_plugin_textdomain('wp-analytify-woocommerce', false, $plugin_dir . '/languages/');
    }

    /**
     * Add custom admin notice.
     *
     * @param  string $message Custom Message
     * @param  string $class wp-analytify-success,wp-analytify-danger
     */

	function wp_analytify_woo_notice( $message, $class = 'wp-analytify-success' ) {
		// Only show notices on allowed pages
		$screen = get_current_screen();
		
		if ( ! $screen ) {
			return;
		}
		
		$allowed_parent_bases = array(
			'analytify-dashboard',
			'plugins',
			'analytify-settings',
			'analytify-license',
			'analytify-addons',
			'dashboard',
		);
		
		$allowed_screen_ids = array(
			'plugins',
			'dashboard',
		);
		
		// Check if we're on an allowed page.
		$is_allowed = in_array( $screen->parent_base, $allowed_parent_bases, true )
			|| in_array( $screen->id, $allowed_screen_ids, true )
			|| ( isset( $_GET['page'] ) && strpos( $_GET['page'], 'analytify' ) === 0 );
		
		// Don't show notice if not on allowed page
		if ( ! $is_allowed ) {
			return;
		}
		
		$notice_id = 'analytify_notice_' . md5( $message );
		if ( ! get_option( $notice_id ) ) {
			echo '<div class="wp-analytify-notification '. $class .'" id="'. $notice_id .'">
					<a class="wp-analytify-notice-dismiss" href="#" aria-label="Dismiss the notice" onclick="dismissAnalytifyNotice(\''. $notice_id .'\'); return false;">&times;</a>
					<div class="wp-analytify-notice-logo">
						<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="notice">
					</div>
					<div class="wp-analytify-notice-discription">
						<p>' . $message .'</p>
					</div>
				</div>';
		}
	}
    
    public function wp_analytify_woo_notice_script() {
        ?>
        <script type="text/javascript">
            function dismissAnalytifyNotice(noticeId) {
                document.getElementById(noticeId).style.display = 'none';
                localStorage.setItem('analytify_stats_refreshed_dismissed', '1');
                var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
                var data = {
                    'action': 'dismiss_analytify_notice',
                    'notice_id': noticeId
                };
                jQuery.post(ajaxurl, data, function(response) {
                    console.log(response);
                });
            }
        </script>
        <?php
    }
    
    public function dismiss_analytify_woo_notice() {
        if ( isset( $_POST['notice_id'] ) ) {
            update_option( sanitize_text_field( $_POST['notice_id'] ), true );
            wp_send_json_success();
        } else {
            wp_send_json_error();
        }
    }


}
Analytify_WooCommerce_Loader::get_instance();
