<?php
/**
 * This class will work as the core class that handles the
 * activation and deactivation of analytify pro addons.
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Analytify_Addons_Manager' ) ) {

	class Analytify_Addons_Manager {

		public array  $addons;
		public string $addon_directory;

		public function __construct() {
			$this->addons          = $this->get_addons();
			$this->addon_directory = ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/';
			$this->hooks();
		}

		public function hooks() {
			foreach ( $this->addons as $addon_slug => $data ) {

				if ( 'active' === $data['status'] ) {
					$plugin_base_name = $addon_slug . '/' . $addon_slug . '.php';
					add_action( "activate_{$plugin_base_name}", array( $this, 'prevent_activation') );
				}
			}
			add_action( 'wp_ajax_set_addon_state', array( $this, 'set_addon_state' ) );
		}

		public function prevent_activation() {
			$plugin_page_url = admin_url( 'plugins.php' );
			wp_die(
				sprintf( esc_html__( 'Sorry, This plugin is now activated as a module in Analytify Pro version %1$s%2$s%3$s. It is recommended that you delete it from plugins. %4$sClick here to return to the Dashboard%5$s.', 'wp-analytify-pro' ),
					'<strong>',
					ANALYTIFY_PRO_VERSION, // phpcs:ignore
					'</strong>',
					'<a href="' . esc_url($plugin_page_url) . '">',
					'</a>'
				)
			);
		}
		public function set_addon_state() {
			// Do a security check first.
			if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'addons' ) ) {
				wp_die( esc_html__( 'Sorry, you are not allowed to do that.', 'wp-analytify-pro' ), 403 );
			}

			$addon_slug = sanitize_text_field( $_POST['addon_slug'] );
			$set_state  = sanitize_text_field( $_POST['set_state'] );

			'active' === $set_state
			? $this->activate_addon( $addon_slug )
			: $this->deactivate_addon( $addon_slug );

			echo esc_html( 'Addon ' . $this->addons[ $addon_slug ][ 'name' ] . ' state changed to ' . $this->addons[ $addon_slug ]['status'] );
			wp_die();
		}

		public function get_addons() {

			$addons_saved = get_option( 'wp_analytify_pro_addons' );

			return is_array($addons_saved) ? $addons_saved : [];
		}

		public function load_addons() {

			include_once ABSPATH . 'wp-admin/includes/plugin.php';
			foreach ( $this->addons as $addon_slug => $data ) {

				$plugin_file = $addon_slug . '/' . $addon_slug . '.php';
				$addon_file = $this->addon_directory . $plugin_file;

				if ( 'active' === $data['status'] && file_exists( $addon_file ) && ! is_plugin_active( $plugin_file ) ) {
					require_once $addon_file;
				}
			}
		}

		public function activate_addon( $slug ) {

			$this->addons[ $slug ]['status'] = 'active';

			update_option( 'wp_analytify_pro_addons', $this->addons );

		}

		public function deactivate_addon( $slug ) {

			$this->addons[ $slug ]['status'] = 'inactive';

			update_option( 'wp_analytify_pro_addons', $this->addons );
		}
	}
}
