<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$search_value = isset( $_GET['analytify_sc_search'] ) ? $_GET['analytify_sc_search'] : '';
$search_value = esc_attr( $search_value );

?>

<div class="analytify_general_status analytify_section_keywords_stats analytify_status_box_wraper" data-endpoint-pro="keyword-stats-search-console" data-target=".analytify_section_keywords_stats">
	<div class="analytify_status_header" style="display: flex;">
		<h3 style="width: 25%; padding-top: 14px;">
			<?php esc_html_e( 'Search Console Stats', 'wp-analytify-pro' ); ?>
		</h3>
		<form id="analytify-search-console-search-form" class="analytify-search-form" style="width:100%;">
			<input
				type="text"
				name="analytify_sc_search"
				id="analytify_sc_search"
				class="analytify-search-input"
				style="width: 40%; float:right;"
				placeholder="<?php esc_attr_e( 'Search keywords...', 'wp-analytify-pro' ); ?>"
				value="<?php echo $search_value; ?>" />
		</form>

	</div>
	<div class="analytify_status_body">
		<div class="analytify-search-console-header">
			<div class="analytify-table-toolbar">

			</div>
		</div>
		<div class="analytify_keyword_stats_boxes_wraper stats-wrapper"></div>
	</div>
	<div class="analytify_stats_loading">
		<table class="analytify_data_tables">
			<thead>
				<tr>
					<th class="analytify_txt_left">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row">
						<p class="skt-loading light-gray"></p>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php for ( $i = 0; $i < 5; $i++ ) { ?>
					<tr>
						<td>
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>
<?php
