<?php
/*
Plugin Name: Sity Cloud Login Redirect
Description: Redirect all login-related pages to /go.
Version: 1.0
Author: Youssef Reda
*/

// Block direct access
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Redirect /login and UM login pages to /go
 */
function sitycloud_login_redirect() {

    // الهدف
    $redirect_url = home_url('/go/');

    // المسار الحالي
    $request_uri = $_SERVER['REQUEST_URI'];

    // 1) إعادة توجيه صفحة /login/
    if ( preg_match('#^/login/?$#', $request_uri) ) {
        wp_redirect( $redirect_url );
        exit;
    }

    // 2) إعادة توجيه صفحة Ultimate Member login
    // مثال:
    // /?page_id=340&redirect_to=https....
    if ( isset($_GET['page_id']) && intval($_GET['page_id']) == 340 ) {
        wp_redirect( $redirect_url );
        exit;
    }
}

add_action('template_redirect', 'sitycloud_login_redirect');
