<?php
/**
 * Plugin Name: Sity Cloud Multisite Components Manager
 * Plugin URI: https://sity.cloud
 * Description: إدارة مكوّنات (إضافات) المواقع الفرعية في شبكة ووردبريس – إخفاء صفحة الإضافات الأصلية واستبدالها بصفحة "المكوّنات" تعرض إضافات محددة يحددها أدمن الشبكة فقط.
 * Author: Sity Cloud
 * Author URI: https://sity.cloud
 * Network: true
 * Version: 1.1.0
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('SityCloud_Multisite_Components_Manager')) {

    class SityCloud_Multisite_Components_Manager {

        const OPTION_ALLOWED_PLUGINS = 'sitycloud_allowed_plugins';

        public function __construct() {
            // اشتغل فقط لو ملتي سايت
            if (!is_multisite()) {
                add_action('admin_notices', [$this, 'notice_not_multisite']);
                return;
            }

            // إعدادات أدمن الشبكة
            add_action('network_admin_menu', [$this, 'register_network_admin_page']);

            // تعديل قوائم لوحة تحكم المواقع الفرعية
            add_action('admin_menu', [$this, 'modify_subsite_menus'], 999);

            // حماية صفحة الإضافات الأصلية وتحويلها لصفحة "المكوّنات"
            add_action('admin_init', [$this, 'block_default_plugins_screens']);

            // معالجة تفعيل/إلغاء تفعيل الإضافات من صفحة المكوّنات
            add_action('admin_init', [$this, 'handle_components_actions']);
        }

        /**
         * تنبيه لو الموقع مش ملتي سايت
         */
        public function notice_not_multisite() {
            if (!current_user_can('manage_options')) {
                return;
            }
            echo '<div class="notice notice-error"><p><strong>Sity Cloud Multisite Components Manager:</strong> هذا البلجن يعمل فقط على شبكة ووردبريس (Multisite).</p></div>';
        }

        /**
         * صفحة إعدادات في لوحة أدمن الشبكة لاختيار الإضافات المسموح بها للمواقع الفرعية
         */
        public function register_network_admin_page() {
            add_menu_page(
                'مكوّنات Sity Cloud',
                'مكوّنات Sity Cloud',
                'manage_network_plugins',
                'sitycloud-network-components',
                [$this, 'render_network_admin_page'],
                'dashicons-admin-plugins',
                30
            );
        }

        /**
         * عرض صفحة إعدادات أدمن الشبكة
         */
        public function render_network_admin_page() {
            if (!current_user_can('manage_network_plugins')) {
                wp_die(__('غير مسموح لك بالوصول لهذه الصفحة.', 'sitycloud-components'));
            }

            // تحميل دالة get_plugins
            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            // حفظ الإعدادات
            if (isset($_POST['sitycloud_save_allowed_plugins'])) {
                check_admin_referer('sitycloud_save_allowed_plugins_nonce', 'sitycloud_nonce');

                $allowed = isset($_POST['sitycloud_allowed_plugins']) && is_array($_POST['sitycloud_allowed_plugins'])
                    ? array_map('sanitize_text_field', $_POST['sitycloud_allowed_plugins'])
                    : [];

                update_site_option(self::OPTION_ALLOWED_PLUGINS, $allowed);

                echo '<div class="notice notice-success is-dismissible"><p>تم تحديث المكوّنات المسموح بها للمواقع الفرعية بنجاح.</p></div>';
            }

            $all_plugins     = get_plugins();
            $allowed_plugins = get_site_option(self::OPTION_ALLOWED_PLUGINS, []);

            ?>
            <div class="wrap">
                <h1 style="margin-bottom: 10px;">إدارة مكوّنات Sity Cloud للمواقع الفرعية</h1>
                <p style="max-width: 700px;">
                    من هنا تقدر تحدد أي الإضافات (Plugins) اللي هتظهر للمواقع الفرعية في صفحة "المكوّنات".
                    أصحاب المواقع الفرعية يقدروا يفعّلوا أو يوقفوا الإضافات اللي هتختارها هنا فقط.
                </p>

                <form method="post" action="">
                    <?php wp_nonce_field('sitycloud_save_allowed_plugins_nonce', 'sitycloud_nonce'); ?>

                    <table class="widefat fixed striped">
                        <thead>
                        <tr>
                            <th style="width: 60px;">سماح</th>
                            <th>الإضافة</th>
                            <th>الملف</th>
                            <th>الوصف</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        if (!empty($all_plugins)) {
                            foreach ($all_plugins as $plugin_file => $plugin_data) {
                                $checked = in_array($plugin_file, $allowed_plugins, true) ? 'checked="checked"' : '';
                                ?>
                                <tr>
                                    <td>
                                        <input type="checkbox"
                                               name="sitycloud_allowed_plugins[]"
                                               value="<?php echo esc_attr($plugin_file); ?>"
                                               <?php echo $checked; ?> />
                                    </td>
                                    <td>
                                        <strong><?php echo esc_html($plugin_data['Name']); ?></strong><br>
                                        <small>الإصدار: <?php echo esc_html($plugin_data['Version']); ?> - الكاتب:
                                            <?php echo wp_kses_post($plugin_data['Author']); ?></small>
                                    </td>
                                    <td><code><?php echo esc_html($plugin_file); ?></code></td>
                                    <td><?php echo esc_html($plugin_data['Description']); ?></td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="4">لا توجد إضافات مثبتة حالياً.</td>
                            </tr>
                            <?php
                        }
                        ?>
                        </tbody>
                    </table>

                    <p style="margin-top: 15px;">
                        <button type="submit" class="button button-primary" name="sitycloud_save_allowed_plugins" value="1">
                            حفظ المكوّنات المسموح بها
                        </button>
                    </p>
                </form>
            </div>
            <?php
        }

        /**
         * تعديل قائمة لوحة التحكم في المواقع الفرعية:
         * - إخفاء "الإضافات"
         * - إضافة "المكوّنات"
         */
        public function modify_subsite_menus() {
            // لا نغيّر شيء في لوحة أدمن الشبكة نفسها
            if (is_network_admin()) {
                return;
            }

            // نشتغل فقط داخل لوحة تحكم wp-admin
            if (!is_admin()) {
                return;
            }

            // إخفاء صفحة الإضافات الافتراضية عن كل المستخدمين في المواقع الفرعية
            remove_menu_page('plugins.php');

            // إضافة صفحة "المكوّنات"
            add_menu_page(
                'المكوّنات',
                'المكوّنات',
                'activate_plugins', // أصحاب المواقع يقدروا يتحكموا في التفعيل/التعطيل
                'sitycloud-components',
                [$this, 'render_components_page'],
                'dashicons-admin-plugins',
                65
            );
        }

        /**
         * منع الوصول لصفحات الإضافات الأصلية وإعادة التوجيه إلى "المكوّنات"
         */
        public function block_default_plugins_screens() {
            if (is_network_admin()) {
                // في لوحة الشبكة نسيب الإضافات تشتغل عادي
                return;
            }

            if (!is_admin()) {
                return;
            }

            global $pagenow;

            $blocked_pages = [
                'plugins.php',
                'plugin-install.php',
                'plugin-editor.php',
            ];

            if (in_array($pagenow, $blocked_pages, true)) {
                wp_safe_redirect(admin_url('admin.php?page=sitycloud-components'));
                exit;
            }
        }

        /**
         * صفحة المكوّنات في المواقع الفرعية
         */
        public function render_components_page() {
            if (!current_user_can('activate_plugins')) {
                wp_die(__('غير مسموح لك بالوصول لهذه الصفحة.', 'sitycloud-components'));
            }

            // تحميل دوال الإضافات
            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }
            if (!function_exists('is_plugin_active')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            $all_plugins      = get_plugins();
            $allowed_plugins  = get_site_option(self::OPTION_ALLOWED_PLUGINS, []);

            // تصفية الإضافات المسموح بها فقط
            $display_plugins = [];
            foreach ($allowed_plugins as $plugin_file) {
                if (isset($all_plugins[$plugin_file])) {
                    $display_plugins[$plugin_file] = $all_plugins[$plugin_file];
                }
            }

            ?>
            <div class="wrap sitycloud-components-wrap">
                <h1 style="margin-bottom: 10px;">مكوّنات موقعك – Sity Cloud</h1>
                <p style="max-width: 700px;">
                    هنا هتلاقي مجموعة الإضافات اللي أدمن شبكة <strong>Sity Cloud</strong> سمح لك تستخدمها في موقعك.
                    تقدر تفعّل أو توقف أي إضافة من القائمة دي بكل سهولة.
                </p>

                <style>
                    .sitycloud-components-wrap .sc-card {
                        background: rgba(255, 255, 255, 0.95);
                        border-radius: 12px;
                        padding: 16px 18px;
                        margin-bottom: 12px;
                        box-shadow: 0 8px 20px rgba(0,0,0,0.04);
                        border: 1px solid rgba(120, 81, 169, 0.12);
                    }
                    .sitycloud-components-wrap .sc-card-header {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        margin-bottom: 8px;
                    }
                    .sitycloud-components-wrap .sc-status-badge {
                        padding: 4px 10px;
                        border-radius: 999px;
                        font-size: 11px;
                        font-weight: 600;
                    }
                    .sitycloud-components-wrap .sc-status-active {
                        background: rgba(46, 204, 113, 0.12);
                        color: #2ecc71;
                        border: 1px solid rgba(46, 204, 113, 0.4);
                    }
                    .sitycloud-components-wrap .sc-status-inactive {
                        background: rgba(149, 165, 166, 0.12);
                        color: #7f8c8d;
                        border: 1px solid rgba(149, 165, 166, 0.4);
                    }
                    .sitycloud-components-wrap .sc-actions form {
                        display: inline-block;
                        margin-left: 4px;
                    }
                    .sitycloud-components-wrap .button-sc-primary {
                        background: linear-gradient(135deg, #7c3aed, #a855f7);
                        border: none;
                        color: #fff;
                        box-shadow: 0 4px 12px rgba(124, 58, 237, 0.35);
                    }
                    .sitycloud-components-wrap .button-sc-primary:hover {
                        background: linear-gradient(135deg, #6d28d9, #9333ea);
                        color: #fff;
                    }
                    .sitycloud-components-wrap .button-sc-secondary {
                        border-color: rgba(148, 163, 184, 0.6);
                    }
                </style>

                <?php
                // رسائل نجاح/فشل
                if (isset($_GET['sc-msg'])) {
                    $msg_code = sanitize_text_field($_GET['sc-msg']);
                    if ($msg_code === 'activated') {
                        echo '<div class="notice notice-success is-dismissible"><p>تم تفعيل المكوّن بنجاح.</p></div>';
                    } elseif ($msg_code === 'deactivated') {
                        echo '<div class="notice notice-success is-dismissible"><p>تم إيقاف المكوّن بنجاح.</p></div>';
                    } elseif ($msg_code === 'error') {
                        echo '<div class="notice notice-error is-dismissible"><p>حدث خطأ أثناء تنفيذ العملية. برجاء المحاولة مرة أخرى.</p></div>';
                    }
                }
                ?>

                <?php if (empty($display_plugins)) : ?>
                    <div class="notice notice-info">
                        <p>لا توجد مكوّنات متاحة حاليًا لهذا الموقع. برجاء التواصل مع دعم <strong>Sity Cloud</strong> لو حابب تفعيل مكوّنات معينة.</p>
                    </div>
                <?php else : ?>

                    <?php foreach ($display_plugins as $plugin_file => $plugin_data) :
                        $is_active = is_plugin_active($plugin_file);
                        ?>
                        <div class="sc-card">
                            <div class="sc-card-header">
                                <div>
                                    <strong><?php echo esc_html($plugin_data['Name']); ?></strong><br>
                                    <small>الإصدار: <?php echo esc_html($plugin_data['Version']); ?> – الكاتب:
                                        <?php echo wp_kses_post($plugin_data['Author']); ?></small>
                                </div>
                                <div>
                                    <span class="sc-status-badge <?php echo $is_active ? 'sc-status-active' : 'sc-status-inactive'; ?>">
                                        <?php echo $is_active ? 'مُفعّل' : 'غير مُفعّل'; ?>
                                    </span>
                                </div>
                            </div>
                            <div style="margin-bottom: 10px; color:#4b5563;">
                                <?php echo esc_html($plugin_data['Description']); ?>
                            </div>
                            <div class="sc-actions">
                                <?php if ($is_active) : ?>
                                    <form method="post" action="">
                                        <?php wp_nonce_field('sitycloud_components_action_nonce', 'sitycloud_components_nonce'); ?>
                                        <input type="hidden" name="sitycloud_action" value="deactivate">
                                        <input type="hidden" name="sitycloud_plugin" value="<?php echo esc_attr($plugin_file); ?>">
                                        <button type="submit" class="button button-secondary button-sc-secondary">
                                            إيقاف التفعيل
                                        </button>
                                    </form>
                                <?php else : ?>
                                    <form method="post" action="">
                                        <?php wp_nonce_field('sitycloud_components_action_nonce', 'sitycloud_components_nonce'); ?>
                                        <input type="hidden" name="sitycloud_action" value="activate">
                                        <input type="hidden" name="sitycloud_plugin" value="<?php echo esc_attr($plugin_file); ?>">
                                        <button type="submit" class="button button-primary button-sc-primary">
                                            تفعيل المكوّن
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>

                <?php endif; ?>

                <p style="margin-top: 20px; color:#6b7280; font-size: 12px;">
                    هذا النظام مُدار بواسطة <strong>Sity Cloud</strong> – تحكم مركزي في مكوّنات الشبكة مع حرية تفعيل/إلغاء التفعيل لأصحاب المواقع.
                </p>
            </div>
            <?php
        }

        /**
         * معالجة تفعيل/إلغاء تفعيل الإضافات من صفحة المكوّنات
         */
        public function handle_components_actions() {
            if (is_network_admin()) {
                return;
            }

            if (!is_admin()) {
                return;
            }

            if (!isset($_POST['sitycloud_action'], $_POST['sitycloud_plugin'])) {
                return;
            }

            if (!current_user_can('activate_plugins')) {
                return;
            }

            if (!isset($_POST['sitycloud_components_nonce']) ||
                !wp_verify_nonce($_POST['sitycloud_components_nonce'], 'sitycloud_components_action_nonce')) {
                return;
            }

            $action      = sanitize_text_field($_POST['sitycloud_action']);
            $plugin_file = sanitize_text_field($_POST['sitycloud_plugin']);

            // مسموح بيه أصلاً؟
            $allowed_plugins = get_site_option(self::OPTION_ALLOWED_PLUGINS, []);
            if (!in_array($plugin_file, $allowed_plugins, true)) {
                wp_safe_redirect(add_query_arg('sc-msg', 'error', admin_url('admin.php?page=sitycloud-components')));
                exit;
            }

            if (!function_exists('activate_plugin')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            if ($action === 'activate') {
                $result = activate_plugin($plugin_file);
                if (is_wp_error($result)) {
                    wp_safe_redirect(add_query_arg('sc-msg', 'error', admin_url('admin.php?page=sitycloud-components')));
                    exit;
                }
                wp_safe_redirect(add_query_arg('sc-msg', 'activated', admin_url('admin.php?page=sitycloud-components')));
                exit;
            } elseif ($action === 'deactivate') {
                deactivate_plugins($plugin_file, false, false);
                wp_safe_redirect(add_query_arg('sc-msg', 'deactivated', admin_url('admin.php?page=sitycloud-components')));
                exit;
            }
        }

    }

    new SityCloud_Multisite_Components_Manager();
}
