<?php
/*
Plugin Name: Tutor LMS Multisite Users Fix
Description: Fix Tutor LMS wrong users table name on multisite by creating views per blog.
Author: Sity Cloud Fix
Version: 1.0
Network: true
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * إنشاء VIEW لجدول المستخدمين الغلط اللي Tutor بيطلبه
 * وربطه بجدول المستخدمين الأساسي في الشبكة.
 */
function sity_tutor_fix_create_users_view_for_blog( $blog_id ) {
    global $wpdb;

    // جدول المستخدمين الأساسي في الشبكة، مثلاً: wpd0_users
    $base_users_table = $wpdb->base_prefix . 'users';

    // البريفكس الخاص بالموقع الفرعي، مثلاً: wpd0_13_
    $blog_prefix = $wpdb->get_blog_prefix( $blog_id );

    // الاسم اللي Tutor بيطلبه: wpd0_13_wpd0_users
    $view_name = $blog_prefix . $base_users_table;

    // SQL لإنشاء أو استبدال الـ VIEW
    $sql = "CREATE OR REPLACE VIEW `$view_name` AS SELECT * FROM `$base_users_table`;";

    $wpdb->query( $sql );
}

/**
 * تشغيل مرة واحدة عند تفعيل البلجن:
 * يعمل VIEW لكل المواقع الفرعية الموجودة بالفعل.
 */
function sity_tutor_fix_activate_for_all_blogs() {
    global $wpdb;

    // جدول المواقع في المالتي سايت
    $blogs = $wpdb->get_results( "SELECT blog_id FROM $wpdb->blogs" );

    if ( $blogs ) {
        foreach ( $blogs as $blog ) {
            sity_tutor_fix_create_users_view_for_blog( (int) $blog->blog_id );
        }
    }
}
register_activation_hook( __FILE__, 'sity_tutor_fix_activate_for_all_blogs' );

/**
 * لما يتعمل موقع جديد في الشبكة، نعمل له VIEW تلقائي.
 */
function sity_tutor_fix_on_new_blog( $blog_id ) {
    sity_tutor_fix_create_users_view_for_blog( $blog_id );
}
add_action( 'wpmu_new_blog', 'sity_tutor_fix_on_new_blog', 10, 1 );
