function enableAnalytifyTableSorting() {
    jQuery('.analytify_data_tables thead th, .wp_analytify_campaign_paginated thead th')
        .off('click')
        .on('click', function () {
            var $header = jQuery(this);
            var $table = $header.closest('table');
            var $tbody = $table.find('tbody'); 
            var $rows = $tbody.find('tr').toArray();
            var columnIndex = $header.index(); 

            // Skip sorting for the first column if it is labeled '#'
            if (columnIndex === 0 && $table.find('thead th').eq(0).text().trim() === '#') {
                return;
            }

            // Do not sort if the table is empty or has only one row
            if ($rows.length <= 1) {
                return;
            }

            // Determine the sort direction: ascending if not already sorted-asc
            var ascending = !$header.hasClass('sorted-asc');
            $table.find('th').removeClass('sorted-asc sorted-desc');
            $header.addClass(ascending ? 'sorted-asc' : 'sorted-desc');

            // Perform the actual sorting
            $rows.sort(function (rowA, rowB) {
                // Get the text content from the clicked column in each row
                var cellA = jQuery(rowA).find('td').eq(columnIndex).text().trim();
                var cellB = jQuery(rowB).find('td').eq(columnIndex).text().trim();

                // Try to parse numbers (e.g., 1,000 → 1000) for numeric sorting
                var numberA = parseFloat(cellA.replace(/,/g, ''));
                var numberB = parseFloat(cellB.replace(/,/g, ''));

                if (!isNaN(numberA) && !isNaN(numberB)) {
                    // If both cells contain numbers, sort numerically
                    return ascending ? numberA - numberB : numberB - numberA;
                } else {
                    // Otherwise, sort as strings (case-insensitive)
                    return ascending
                        ? cellA.toLowerCase().localeCompare(cellB.toLowerCase())
                        : cellB.toLowerCase().localeCompare(cellA.toLowerCase());
                }
            });

            // Append sorted rows back into the tbody
            jQuery.each($rows, function (index, row) {
                $tbody.append(row);
            });

            // If the first column is a row number column (labeled '#'), re-index it
            if ($table.find('thead th').eq(0).text().trim() === '#') {
                $tbody.find('tr').each(function (index) {
                    jQuery(this).find('td').eq(0).text(index + 1);
                });
            }
        });
}
