<?php
/**
 * This file is responsible for initializing ads tracking.
 *
 * @package wp-analytify-pro
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Analytify_Google_Ads_Tracking{

	/**
	 * @var bool The tracking ads option.
	 */
	public $track_ads            = false;

	/**
	 * @var bool|string The conversion ID.
	 */
	public $ads_conversion_id    = false;

	/**
	 * @var bool|string The conversion label.
	 */
	public $ads_conversion_label = false;

	/**
	 * @var null|Analytify_Google_Ads_Tracking The Single object of this class..
	 */
	public static $instance      = null;

	/**
	 * Analytify_Google_Ads_Tracking class constructor.
	 */
	public function __construct() {

		$this->set_addon_option_values();
		$this->includes();
		$this->hooks();
		$this->instantiate_ecommerce_conversion_tracking();

	}

	/**
	 * Return the single instance
	 * of the class.
	 */
	public static function get_instance() {

		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;

	}

	/**
	 * Set the option values saved for the
	 * module in class properties.
	 */
	public function set_addon_option_values() {

		$google_ads_tracking_options = get_option( 'analytify-google-ads-tracking' );

		if ( ! is_array( $google_ads_tracking_options ) ) {
			return;
		};

		$this->track_ads            = isset( $google_ads_tracking_options['ads_conversion_tracking'] ) ? $google_ads_tracking_options['ads_conversion_tracking'] : false;

		$this->ads_conversion_id    = isset( $google_ads_tracking_options['ads_conversion_id'] ) ? $google_ads_tracking_options['ads_conversion_id'] : false;

		$this->ads_conversion_label = isset( $google_ads_tracking_options['ads_conversion_label'] ) ? $google_ads_tracking_options['ads_conversion_label'] : false;

	}

	/**
	 * Includes the required files for the module.
	 */
	public function includes() {
		// Including google ads module settings.
		require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/ads-module-settings.php';
		require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/integrations/traits/Class-WooCommerce-Helpers.php';
		require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/integrations/traits/class-edd-helpers.php';
		require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/integrations/Class-Analytify-Ads-WooCommerce.php';
		require_once ANALYTIFY_PRO_ROOT_PATH . '/inc/modules/google-ads/integrations/Class-Analytify-Ads-EDD.php';
	}

	/**
	 * Check if WooCommerce or EDD exists and it's the order received page.
	 * After that check for module settings if the ads tracking is on
	 * and user has added some conversion id.
	 *
	 * Instatiate the classes.
	 */
	public function instantiate_ecommerce_conversion_tracking() {


		$should_track_ads             = $this->track_ads && $this->ads_conversion_id && $this->ads_conversion_label;

		if ( class_exists( 'WooCommerce' ) && $should_track_ads ) {

			new Analytify_Ads_WooCommerce( $this->ads_conversion_id, $this->ads_conversion_label );

		}

		if ( class_exists( 'Easy_Digital_Downloads' ) && $should_track_ads ) {

			new Analytify_Ads_EDD( $this->ads_conversion_id, $this->ads_conversion_label );

		}

	}

	/**
	 * Add conversion related hooks.
	 */
	public function hooks() {

		add_action( 'analytify_tracking_code_before_pageview', array( $this, 'analytify_ads_tracking_code_callback' ) );

	}

	/**
	 * Add a gtag config command in the main Analytics script for google
	 * Conversion Id.
	 */
	public function analytify_ads_tracking_code_callback() {

		if ( ! empty( $this->ads_conversion_id ) ) {

			echo "gtag( 'config', '" . esc_html( $this->ads_conversion_id ) . "' );";

		}

	}

}

Analytify_Google_Ads_Tracking::get_instance();





