<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'ANALYTIFY_PRO_CAMPAIGNS' ) ) {
	/**
	 * Primary class of the add-on.
	 */
	class ANALYTIFY_PRO_CAMPAIGNS extends WP_Analytify_Pro_Base {

		/**
		 * Class instance.
		 *
		 * @var object
		 */
		private static $instance;

		/**
		 * Get the instance of this class.
		 *
		 * @return object
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Constructor.
		 */
		private function __construct() {
			parent::__construct();
			$this->setup_constants();
			$this->hooks();
		}

		/**
		 * Setup plugin constants
		 *
		 * @access      private
		 * @since       1.0.0
		 * @return      void
		 */
		private function setup_constants() {

			// Setting global values.
			$this->define( 'CAMPAIGNS_ANALYTIFY_PLUGIN_FILE', __FILE__ );
			$this->define( 'CAMPAIGNS_ANALYTIFY_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
			$this->define( 'CAMPAIGNS_ANALYTIFY_PLUGIN_DIR', dirname( __FILE__ ) );
			$this->define( 'CAMPAIGNS_ANALYTIFY_PRODUCT_NAME', 'Google Analytics Campaigns Manager' );
			$this->define( 'CAMPAIGNS_ANALYTIFY_PRODUCT_ID', 6393 );
			$this->define( 'CAMPAIGNS_ANALYTIFY_STORE_URL', 'https://analytify.io' );
		}

		/**
		 * Register hooks.
		 *
		 * @return void
		 */
		private function hooks() {

			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
			// For modifying the meta links.
			add_action( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );

			add_action( 'analytify_dashboad_dropdown_option', array( $this, 'dashboard_dropdown_option' ) );
			add_action( 'analytify_add_submenu', array( $this, 'add_submenu' ), 30 );

			add_filter( 'analytify_enhanced_general_filter', array( $this, 'analytify_enhanced_general_filter' ) );
			add_filter( 'analytify_enhanced_geographic_filter', array( $this, 'analytify_enhanced_geographic_filter' ) );
			add_filter( 'analytify_enhanced_roi_filter', array( $this, 'analytify_enhanced_roi_filter' ) );
			add_filter( 'analytify_enhanced_coupon_filter', array( $this, 'analytify_enhanced_coupon_filter' ) );
			add_filter( 'analytify_admin_bar_menu', array( $this, 'add_admin_bar_menu' ), 25, 1 );

			add_action( 'page_campaigns', array( $this, 'include_content_campaigns' ) );

		}

		/**
		 * Plugin row meta links.
		 *
		 * @param array  $input Already defined meta links.
		 * @param string $file  Plugin file path and name being processed.
		 * @return array
		 */
		public function plugin_row_meta( $input, $file ) {

			// Exit if its other plugins.
			if ( 'wp-analytify-campaigns/wp-analytify-campaigns.php' !== $file ) {
				return $input;
			}

			// Remove the 'view details' org link.
			unset( $input[2] );

			// Add the plugin site link.
			$input[] = '<a target="_blank" href="https://analytify.io/add-ons/campaigns/">' . esc_html__( 'Visit plugin site', 'wp-analytify-campaings' ) . '</a>';

			return $input;
		}

		/**
		 * Add submenu page for campaigns.
		 *
		 * @since 1.0.0
		 */
		public function add_submenu() {

			add_submenu_page(
				'analytify-dashboard',
				ANALYTIFY_NICK . esc_html__( 'Campaigns', 'wp-analytify-campaings' ),
				esc_html__( 'Campaigns', 'wp-analytify-campaings' ),
				'read',
				'analytify-campaigns',
				array(
					$this,
					'load_main_dashboard',
				),
				20
			);
		}

		/**
		 * Load the main dashboard view.
		 *
		 * @return void
		 */
		public function load_main_dashboard() {
			include_once ANALYTIFY_PRO_CAMPAIGNS_ADDON_ROOT_PATH . '/views/main-dashboard.php';
		}

		/**
		 * Add dropdown option for campaigns dashboard.
		 *
		 * @since 1.0.0
		 */
		public function dashboard_dropdown_option() {
			echo '<li><a href="' . admin_url( 'admin.php?page=analytify-campaigns' ) . '">' . ec_html__( 'Campaigns', 'wp-analytify-campaings' ) . '</a></li>';
		}

		/**
		 * Enqueue admin scripts and styles.
		 *
		 * @param string $page - WP page.
		 * @return void
		 */
		public function admin_scripts( $page ) {
			if ( 'analytify_page_analytify-campaigns' === $page || $page === 'analytify_page_analytify-settings' ) {
				// wp_enqueue_script( 'analytify_campaigns_script', plugins_url( 'assets/js/main.js', __DIR__ ), array( 'jquery', 'jquery-ui-tooltip' ), ANALTYIFY_PRO_CAMPAIGNS_ADDON_VERSION );

				// TODO: fix this mess.
				wp_localize_script(
					'analytify_campaigns_script',
					'analytify_campaigns',
					array(
						'resturl'   => wp_json_encode( esc_url_raw( rest_url( 'wp-analytify/v1/get_pro_campaigns_report/campaigns-detail' ) ) ),
						'restnonce' => wp_create_nonce( 'wp_rest' ),
					)
				);
			}
		}

		/**
		 * Change WooCommerce query filter.
		 *
		 * @param string $filter GA filters.
		 *
		 * @since 1.0.4
		 */
		public function analytify_enhanced_general_filter() {
			if ( isset( $_GET['cn'] ) ) {
				$campaign = sanitize_text_field( wp_unslash( $_GET['cn'] ) );
				return 'ga:campaign==' . $campaign;
			}
			return false;
		}

		/**
		 * Change WooCommerce query filter.
		 *
		 * @param string $filter GA filters.
		 *
		 * @since 1.0.4
		 */
		public function analytify_enhanced_geographic_filter( $filter ) {
			if ( isset( $_GET['cn'] ) ) {
				$campaign = sanitize_text_field( wp_unslash( $_GET['cn'] ) );
				$filter  .= ';ga:campaign==' . $campaign;
			}
			return $filter;
		}

		/**
		 * Change WooCommerce query filter.
		 *
		 * @param string $filter GA filters.
		 *
		 * @since 1.0.4
		 */
		public function analytify_enhanced_roi_filter( $filter ) {
			if ( isset( $_GET['cn'] ) ) {
				$campaign = sanitize_text_field( wp_unslash( $_GET['cn'] ) );
				$filter  .= ';ga:campaign==' . $campaign;
			}
			return $filter;
		}

		/**
		 * Change WooCommerce query filter.
		 *
		 * @param string $filter GA filters.
		 *
		 * @since 1.0.4
		 */
		public function analytify_enhanced_coupon_filter( $filter ) {
			if ( isset( $_GET['cn'] ) ) {
				$campaign = sanitize_text_field( wp_unslash( $_GET['cn'] ) );
				$filter  .= ';ga:campaign==' . $campaign;
			}
			return $filter;
		}

		/**
		 * Add option in admin bar.
		 *
		 * @param array $menus Menu array.
		 *
		 * @since 1.0.5
		 */
		public function add_admin_bar_menu( $menus ) {

			$menus['analytify-campaigns'] = __( 'Campaigns', 'wp-analytify-campaings' );
			return $menus;
		}

		/**
		 * Define constant if not already set
		 *
		 * @param string      $name  Constant name.
		 * @param string|bool $value Constant value.
		 */
		private function define( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}
	}

	ANALYTIFY_PRO_CAMPAIGNS::get_instance();
}
