<?php

/**
 * Function to display the Geographical stats by Countries as well as Cities.
 *
 * @param WP_Analytify $Analytify_Email
 * @param array $countries
 * @param array $cities
 * @return void
 */
function pa_geopgraphic_lisiting( $Analytify_Email, $countries, $cities ) {

	ob_start();
	$display = '';
	$width = $display ? '50%' : '100%';
	?>

	<!--Start Geographic.-->
	<tr>
		<td valign="top" style="border: 1px solid #e2e5e8;">
		<table width="100%" cellspacing="0" cellpadding="0" border="0" align="center" bgcolor="#f9fafa" >
			<tr>
			<td style="font: normal 16px 'Roboto slab', Arial, Helvetica, sans-serif; padding: 11px 20px;"><font color="#444444"><?php analytify_e( 'Geographical Statistics', 'wp-analytify' ) ?></font></td>
			</tr>
		</table>
		</td>
	</tr>
	<tr>
		<td style="border:1px solid #e2e5e8; border-top-width: 0;"  bgcolor="#ffffff" >
		<table width="100%" cellpadding="0" cellspacing="0" border="0" class="geographic-table">
			<tr>
			<?php
			 /**
			  * Analytify Email filter to hide countries if filter applied in functions.php 
			  *
			  * @param $display (in filter its value will be passed false inorder to hide the countries)
			  *
			  * For more details refer: https://analytify.io/doc/analytify-filters/#display-number-of-visitors-by-either-countries-or-cities-as-geographical-stats-in-email-reports
			  */
			if (apply_filters('display_email_countries_table', $display = true)) :  
			?>
			<td width="<?php echo esc_html($width); ?>"  valign="top" style="border-right:1px solid #e2e5e8;">
				<table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
				<tr>
					<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif; border-bottom: 1px solid #e2e5e8;" bgcolor="#f5f9ff" colspan="2"><font color="#444444"><?php analytify_e( 'Top Countries', 'wp-analytify' ) ?></font></td>
					<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-left: 1px solid #e2e5e8; border-bottom: 1px solid #e2e5e8;" bgcolor="#f5f9ff" width="50" align="right"><font color="#444444"><?php analytify_e( 'Visitors', 'wp-analytify' ) ?></font></td>
				</tr>

				<?php if ( isset( $countries['rows'] ) ): ?>
					<?php foreach ( $countries['rows'] as $country ): ?>
						<tr>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;" width="20"><img src="<?php echo ANALYTIFY_IMAGES_PATH . pretty_class( $country['country'] ) . '.png' ?>" alt="" /></td>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;"><font color="#444444"><?php echo $country['country'] ?></font></td>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;" align="right"><font color="#444444"><?php echo WPANALYTIFY_Utils::pretty_numbers( $country['sessions'] ) ?></font></td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>

				</table>
			</td>
			<?php endif; ?>
			<?php
			/**
			  * Analytify Email filter to hide cities if filter applied in functions.php 
			  *
			  * @param $display (in filter its value will be passed false inorder to hide the cities)
			  *
			  * For more details refer: https://analytify.io/doc/analytify-filters/#display-number-of-visitors-by-either-countries-or-cities-as-geographical-stats-in-email-reports
			  */ 
			 if (apply_filters('display_email_cities_table', $display = true)) :  
			 ?>
			<td width="<?php echo esc_html($width); ?>" valign="top">
				<table width="100%" border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
				<tr>
					<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;" bgcolor="#f5f9ff" colspan="2"><font color="#444444"><?php _e( 'Top Cities', 'wp-analytify-email' ) ?></font></td>
					<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-left: 1px solid #e2e5e8;" bgcolor="#f5f9ff" width="50" align="right"><font color="#444444"><?php analytify_e( 'Visitors', 'wp-analytify' ) ?></font></td>
				</tr>

				<?php if ( isset( $cities['rows'] ) ): ?>
					<?php foreach ( $cities['rows'] as $city ): ?>
						<tr>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;" width="20">
								<?php 
								$country_name = !empty($city['country']) ? ($city['country'] === 'Türkiye' ? 'Turkey' : $city['country']) : 'N/A';
								?>
								<img src="<?php echo ANALYTIFY_IMAGES_PATH . pretty_class( $country_name ) . '.png' ?>" alt="<?php echo !empty($city['country']) ? $city['country'] : 'N/A'; ?>" />
							</td>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;"><font color="#444444"><?php echo !empty($city['city']) ? $city['city'] : '<em>N/A</em>'; ?></font></td>
							<td style="padding:15px; font: 400 13px 'Roboto', Arial, Helvetica, sans-serif;border-top: 1px solid #e2e5e8;" align="right"><font color="#444444"><?php echo WPANALYTIFY_Utils::pretty_numbers(  $city['sessions'] ) ?></font></td>
						</tr>
					<?php endforeach; ?>
				<?php endif; ?>

				</table>
			</td>
			<?php endif; ?>
			</tr>
		</table>
		</td>
	</tr>
	<tr>
		<td style="border:1px solid #e2e5e8; border-top: 0;">
		<table cellpadding="0" cellspacing="16" border="0" width="100%" bgcolor="#f9fafa">
			<tr>
			<td width="32" style="text-align: right;"><img src="<?php echo ANALYTIFY_IMAGES_PATH . "anlytify_about_icon.png" ?>" alt="about icon"/></td>
			<td style="font: normal 13px 'Roboto', Arial, Helvetica, sans-serif;"><font color="#444444"><?php
			/**
			  * Analytify Email filter to hide countries or cities heading based on the condition if filter applied in functions.php 
			  *
			  * @param $display
			  *
			  * By default the first condition is to check if filter is not applied then display heading for both countries and cities.
			  *
			  * For more details refer: https://analytify.io/doc/analytify-filters/#display-number-of-visitors-by-either-countries-or-cities-as-geographical-stats-in-email-reports
			  */
			if (apply_filters('display_email_countries_table', $display) && apply_filters('display_email_cities_table', $display)) {
				analytify_e( 'List of top countries and cities that visited your site.', 'wp-analytify' );
			} elseif (apply_filters('display_email_countries_table', $display)){
				 // Hide the heading related to countries if a filter is applied.
				analytify_e( 'List of top countries that visited your site.', 'wp-analytify' );
			} elseif (apply_filters('display_email_cities_table', $display)){
				 // Hide the heading related to cities if a filter is applied.
				analytify_e( 'List of top cities that visited your site.', 'wp-analytify' );
			}
			 ?></font></td>
			</tr>
		</table>
		</td>
	</tr>
	<tr>
		<td style="padding:15px;"></td>
	</tr>
	<!--End Geographic.-->

	<?php
	$message = ob_get_clean();
	return $message;
}
