<?php

/**
 * Shopping analysis stats.
 *
 * @param object $current
 * @param object $stats
 * @return void
 */
function pa_ga_include_woocommerce( $current, $raw_stats ) {

	ob_start();

	$sessions = isset( $raw_stats['aggregations']['sessions'] ) ? $raw_stats['aggregations']['sessions'] : 0;
	$transactions = isset( $raw_stats['aggregations']['transactions'] ) ? $raw_stats['aggregations']['transactions'] : 0;
	$conversion_rate = $sessions > 0 ? ( $transactions / $sessions ) * 100 : 0;

	$first_puchaser = isset( $raw_stats['aggregations']['firstTimePurchaserRate'] ) ? $raw_stats['aggregations']['firstTimePurchaserRate'] : 0;

	$boxes = array(
		'transactions'        => array(
			'label'       => esc_html__( 'Transactions', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['transactions'] ) ? number_format( $raw_stats['aggregations']['transactions'] ) : 0,
			'description' => esc_html__( 'Transactions is the total number of completed purchases on your site.', 'wp-analytify-woocommerce' ),
		),
		'revenue' => array(
			'label'       => __( 'Transaction Revenues', 'wp-analytify-woocommerce' ),
			'value' => isset( $raw_stats['aggregations']['totalRevenue'] ) 
				? WP_Analytify_WooCommerce_Addon::analytify_format_currency($raw_stats['aggregations']['totalRevenue'], 
					( isset( $raw_stats['currencyCode'] ) && $raw_stats['currencyCode'] !== '(not set)' ) ? $raw_stats['currencyCode'] : '' )
				: WP_Analytify_WooCommerce_Addon::analytify_format_currency(0),
			'description' => __( 'The total sale revenue provided in the transaction including or excluding shipping and tax.', 'wp-analytify-woocommerce' ),
		),
		'average_order_value' => array(
			'label'       => __( 'Average Order Value', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['averagePurchaseRevenue'] ) 
				? WP_Analytify_WooCommerce_Addon::analytify_format_currency($raw_stats['aggregations']['averagePurchaseRevenue'],
					( isset( $raw_stats['currencyCode'] ) && $raw_stats['currencyCode'] !== '(not set)' ) ? $raw_stats['currencyCode'] : '' )
				: WP_Analytify_WooCommerce_Addon::analytify_format_currency(0),
			'description' => __( 'Average Value of transactions.', 'wp-analytify-woocommerce' ),
		),
		'add_to_cart'         => array(
			'label'       => __( 'Product Adds To Cart', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['addToCarts'] ) ? $raw_stats['aggregations']['addToCarts'] : 0,
			'description' => __( 'The total number of items Added in cart whether it is purchased or not.', 'wp-analytify-woocommerce' ),
		),
		'remove_from_cart'    => array(
			'label'       => __( 'Product Removes From Cart', 'wp-analytify-woocommerce' ),
			'value'       => 0,
			'description' => __( 'The total number of items Removed from cart whether it is purchased or not.', 'wp-analytify-woocommerce' ),
		),
		'checkouts'           => array(
			'label'       => __( 'Product Checkouts', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['checkouts'] ) ? $raw_stats['aggregations']['checkouts'] : 0,
			'description' => __( 'The total number of checkouts.', 'wp-analytify-woocommerce' ),
		),
		'unique_purchases'    => array(
			'label'       => __( 'Completed Purchases', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['ecommercePurchases'] ) ? $raw_stats['aggregations']['ecommercePurchases'] : 0,
			'description' => __( 'The number of times users completed a purchase.', 'wp-analytify-woocommerce' ),
		),
		'view_item'           => array(
			'label'       => __( 'Product Clicks', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['itemListClicks'] ) ? $raw_stats['aggregations']['itemListClicks'] : 0,
			'description' => __( 'The total number of user Clicks on your item.', 'wp-analytify-woocommerce' ),
		),
		'view_item_list'      => array(
			'label'       => __( 'Product Detail Views', 'wp-analytify-woocommerce' ),
			'value'       => isset( $raw_stats['aggregations']['itemViews'] ) ? $raw_stats['aggregations']['itemViews'] : 0,
			'description' => __( 'Number of times users viewed the product detail page.', 'wp-analytify-woocommerce' ),
		),
		'conversion_rate' => array(
			'label'       => __( 'Conversion Rate', 'wp-analytify-woocommerce' ),
			'value'       => number_format( $conversion_rate, 2 ) . '%',
			'description' => __( 'The percentage of website sessions resulting in a transaction.', 'wp-analytify-woocommerce' ),
		),
		'new_customers' => array(
			'label'       => __( 'New Customers', 'wp-analytify-woocommerce' ),
			'value'       => number_format( $first_puchaser, 2 ) . '%',
			'description' => __( 'The percentage of first-time purchasers.', 'wp-analytify-woocommerce' ),
		),
	);

	if ( isset( $raw_stats['remove_from_cart'] ) ) {
		$boxes['remove_from_cart']['value'] = $raw_stats['remove_from_cart'];
	} else {
		unset( $boxes['remove_from_cart'] );
	}

	?>
	<div class="analytify_general_status analytify_status_box_wraper">

		<div class="analytify_status_header">
			<h3><?php esc_html_e( 'Overview', 'wp-analytify-woocommerce' ); ?></h3>
		</div>

		<div class="analytify_status_body">
			<div class="analytify_general_status_boxes_wraper">

				<?php foreach ( $boxes as $box ) { ?>
				<div class="analytify_general_status_boxes">
					<h4><?php echo esc_html( $box['label'] ); ?></h4>
					<div class="analytify_general_stats_value"><?php echo esc_html( $box['value'] ); ?></div>
					<p><?php echo esc_html( $box['description'] ); ?></p>
				</div>
				<?php } ?>

			</div>
		</div>

		<?php
		/*
		TODO: missing_ga4
		<div class="analytify_status_footer">
			<span class="analytify_info_stats"><?php
			echo sprintf( esc_html__( 'Did you know that the Conversion Rate in your store is %1$s', 'wp-analytify-woocommerce' ), number_format( $stats->totalsForAllResults['ga:transactionsPerSession'], 2) ) . '%?'; ?></span>
		</div>
		*/
		?>

	</div>

	<?php
	wp_send_json(
		array(
			'body' => ob_get_clean(),
		)
	);
}
