<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Retrieves the search value from the 'analytify_demographic_search' query parameter, or sets it to an empty string if not provided.
$demographic_value = isset( $_GET['analytify_demographic_search'] ) ? $_GET['analytify_demographic_search'] : '';
$demographic_value = esc_attr( $demographic_value );

$interest_value = isset( $_GET['analytify_interests_search'] ) ? $_GET['analytify_interests_search'] : '';
$interest_value = esc_attr( $interest_value );

?>
<div class="analytify_general_status analytify_status_box_wraper" data-endpoint-pro="demographics">
	<div class="analytify_status_header" style="display: flex;">
		<h3 style="width: 25%; padding-top: 14px;">
			<?php esc_html_e( 'Demographic Stats', 'wp-analytify-pro' ); ?>
			<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="demographics"><span class="analytify_tooltiptext"><?php esc_html_e( 'Export Stats', 'wp-analytify-pro' ); ?></span></a>
			<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
		</h3>
		<form id="analytify-demographic-search-form" class="analytify-search-form" style="width:100%;">
			<input
				type="text"
				name="analytify_demographic_search"
				id="analytify_demographic_search"
				class="analytify-search-input"
				style="width: 40%; float:right;"
				placeholder="<?php esc_attr_e( 'Search demographics...', 'wp-analytify-pro' ); ?>"
				value="<?php echo $demographic_value; ?>" />
		</form>
	</div>
	<div class="analytify_status_body">
		<div class="analytify-search-console-header">
			<div class="analytify-table-toolbar">

			</div>
		</div>
		<div class="stats-wrapper"></div>
	</div>
	<div class="analytify_stats_loading">
		<table class="analytify_data_tables">
			<thead>
				<tr>
					<th class="analytify_num_row">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_txt_left">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_txt_left">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row">
						<p class="skt-loading light-gray"></p>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php for ( $i = 0; $i < 5; $i++ ) { ?>
					<tr>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
						<td>
							<p class="skt-loading"></p>
						</td>
						<td>
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>
<div class="analytify_general_status analytify_status_box_wraper" data-endpoint-pro="interests">
	<div class="analytify_status_header" style="display: flex;">
		<h3 style="width: 25%; padding-top: 14px;">
			<?php esc_html_e( 'Interest Stats', 'wp-analytify-pro' ); ?>
			<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="interests"><span class="analytify_tooltiptext"><?php esc_html_e( 'Export Stats', 'wp-analytify-pro' ); ?></span></a>
			<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
		</h3>
		<form id="analytify-interests-search-form" class="analytify-search-form" style="width:100%;">
			<input
				type="text"
				name="analytify_interests_search"
				id="analytify_interests_search"
				class="analytify-search-input"
				style="width: 40%; float:right;"
				placeholder="<?php esc_attr_e( 'Search interests...', 'wp-analytify-pro' ); ?>"
				value="<?php echo $interest_value; ?>" />
		</form>
	</div>
	<div class="analytify_status_body">
		<div class="analytify-search-console-header">
			<div class="analytify-table-toolbar">

			</div>
		</div>
		<div class="stats-wrapper"></div>
	</div>
	<div class="analytify_stats_loading">
		<table class="analytify_data_tables">
			<thead>
				<tr>
					<th class="analytify_txt_left">
						<p class="skt-loading light-gray"></p>
					</th>
					<th class="analytify_value_row right-align">
						<p class="skt-loading light-gray"></p>
					</th>
				</tr>
			</thead>
			<tbody>
				<?php for ( $i = 0; $i < 5; $i++ ) { ?>
					<tr>
						<td>
							<p class="skt-loading"></p>
						</td>
						<td class="analytify_txt_center">
							<p class="skt-loading"></p>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>
